/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.singletable.route;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.route.SQLRouter;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.singletable.route.SingleTableRouteEngine;
import org.apache.shardingsphere.singletable.rule.SingleTableRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateTableStatement;

public final class SingleTableSQLRouter
implements SQLRouter<SingleTableRule> {
    public RouteContext createRouteContext(LogicSQL logicSQL, ShardingSphereMetaData metaData, SingleTableRule rule, ConfigurationProperties props) {
        RouteContext result = new RouteContext();
        if (1 == metaData.getResource().getDataSources().size()) {
            String logicDataSource = rule.getDataSourceNames().iterator().next();
            String actualDataSource = (String)metaData.getResource().getDataSources().keySet().iterator().next();
            result.getRouteUnits().add(new RouteUnit(new RouteMapper(logicDataSource, actualDataSource), Collections.emptyList()));
        } else {
            this.route(logicSQL.getSqlStatementContext(), rule, result, props);
        }
        return result;
    }

    private void route(SQLStatementContext<?> sqlStatementContext, SingleTableRule rule, RouteContext routeContext, ConfigurationProperties props) {
        Collection<String> singleTableNames = this.getSingleTableNames(sqlStatementContext, rule, routeContext);
        if (singleTableNames.isEmpty()) {
            return;
        }
        this.validateSameDataSource(sqlStatementContext, rule, routeContext, props, singleTableNames);
        new SingleTableRouteEngine(singleTableNames, sqlStatementContext.getSqlStatement()).route(routeContext, rule);
    }

    private Collection<String> getSingleTableNames(SQLStatementContext<?> sqlStatementContext, SingleTableRule rule, RouteContext routeContext) {
        HashSet<String> result;
        if (sqlStatementContext instanceof TableAvailable) {
            Collection allTables = ((TableAvailable)sqlStatementContext).getAllTables();
            result = new HashSet<String>(allTables.size(), 1.0f);
            for (SimpleTableSegment each : allTables) {
                String value = each.getTableName().getIdentifier().getValue();
                result.add(value);
            }
        } else {
            result = sqlStatementContext.getTablesContext().getTableNames();
        }
        return routeContext.getRouteUnits().isEmpty() && sqlStatementContext.getSqlStatement() instanceof CreateTableStatement ? result : rule.getSingleTableNames(result);
    }

    private void validateSameDataSource(SQLStatementContext<?> sqlStatementContext, SingleTableRule rule, RouteContext routeContext, ConfigurationProperties props, Collection<String> singleTableNames) {
        boolean sqlFederationEnabled = (Boolean)props.getValue((Enum)ConfigurationPropertyKey.SQL_FEDERATION_ENABLED);
        boolean allTablesInSameDataSource = sqlFederationEnabled ? sqlStatementContext instanceof SelectStatementContext || rule.isSingleTablesInSameDataSource(singleTableNames) : rule.isAllTablesInSameDataSource(routeContext, singleTableNames);
        Preconditions.checkState((boolean)allTablesInSameDataSource, (Object)"All tables must be in the same datasource.");
    }

    public void decorateRouteContext(RouteContext routeContext, LogicSQL logicSQL, ShardingSphereMetaData metaData, SingleTableRule rule, ConfigurationProperties props) {
        this.route(logicSQL.getSqlStatementContext(), rule, routeContext, props);
    }

    public int getOrder() {
        return 0;
    }

    public Class<SingleTableRule> getTypeClass() {
        return SingleTableRule.class;
    }
}

