/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.schedule;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.ingest.DumperConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.HandleConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.ImporterConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.PipelineConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.TaskConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.WorkflowConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datanode.JobDataNodeEntry;
import org.apache.shardingsphere.data.pipeline.api.datanode.JobDataNodeLine;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfigurationFactory;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.impl.ShardingSpherePipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.impl.StandardPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.spi.rulealtered.RuleAlteredJobConfigurationPreparer;
import org.apache.shardingsphere.infra.config.rulealtered.OnRuleAlteredActionConfiguration;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ComplexShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.StandardShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.TableRule;
import org.apache.shardingsphere.sharding.yaml.config.YamlShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.swapper.ShardingRuleConfigurationConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShardingRuleAlteredJobConfigurationPreparer
implements RuleAlteredJobConfigurationPreparer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShardingRuleAlteredJobConfigurationPreparer.class);

    public HandleConfiguration createHandleConfiguration(PipelineConfiguration pipelineConfig, WorkflowConfiguration workflowConfig) {
        HandleConfiguration result = new HandleConfiguration();
        Map<String, List<DataNode>> shouldScalingActualDataNodes = ShardingRuleAlteredJobConfigurationPreparer.getShouldScalingActualDataNodes(pipelineConfig, workflowConfig);
        result.setJobShardingDataNodes(this.getJobShardingDataNodes(shouldScalingActualDataNodes));
        result.setLogicTables(ShardingRuleAlteredJobConfigurationPreparer.getLogicTables(shouldScalingActualDataNodes.keySet()));
        result.setTablesFirstDataNodes(ShardingRuleAlteredJobConfigurationPreparer.getTablesFirstDataNodes(shouldScalingActualDataNodes));
        return result;
    }

    private static Map<String, List<DataNode>> getShouldScalingActualDataNodes(PipelineConfiguration pipelineConfig, WorkflowConfiguration workflowConfig) {
        PipelineDataSourceConfiguration sourceDataSourceConfig = PipelineDataSourceConfigurationFactory.newInstance((String)pipelineConfig.getSource().getType(), (String)pipelineConfig.getSource().getParameter());
        ShardingSpherePipelineDataSourceConfiguration source = (ShardingSpherePipelineDataSourceConfiguration)sourceDataSourceConfig;
        ShardingRuleConfiguration sourceRuleConfig = ShardingRuleConfigurationConverter.findAndConvertShardingRuleConfiguration(source.getRootConfig().getRules());
        ShardingRule shardingRule = new ShardingRule(sourceRuleConfig, source.getRootConfig().getDataSources().keySet());
        Map<String, TableRule> tableRules = shardingRule.getTableRules();
        LinkedHashMap<String, List<DataNode>> result = new LinkedHashMap<String, List<DataNode>>();
        HashSet reShardNeededTables = new HashSet((Collection)workflowConfig.getAlteredRuleYamlClassNameTablesMap().get(YamlShardingRuleConfiguration.class.getName()));
        for (Map.Entry<String, TableRule> entry : tableRules.entrySet()) {
            if (!reShardNeededTables.contains(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue().getActualDataNodes());
        }
        return result;
    }

    private List<String> getJobShardingDataNodes(Map<String, List<DataNode>> actualDataNodes) {
        LinkedList<String> result = new LinkedList<String>();
        Map<String, Map<String, List<DataNode>>> groupedDataSourceDataNodesMap = this.groupDataSourceDataNodesMapByDataSourceName(actualDataNodes);
        for (Map<String, List<DataNode>> each : groupedDataSourceDataNodesMap.values()) {
            ArrayList<JobDataNodeEntry> dataNodeEntries = new ArrayList<JobDataNodeEntry>(each.size());
            for (Map.Entry<String, List<DataNode>> entry : each.entrySet()) {
                dataNodeEntries.add(new JobDataNodeEntry(entry.getKey(), entry.getValue()));
            }
            result.add(new JobDataNodeLine(dataNodeEntries).marshal());
        }
        return result;
    }

    private Map<String, Map<String, List<DataNode>>> groupDataSourceDataNodesMapByDataSourceName(Map<String, List<DataNode>> actualDataNodes) {
        LinkedHashMap<String, Map<String, List<DataNode>>> result = new LinkedHashMap<String, Map<String, List<DataNode>>>();
        for (Map.Entry<String, List<DataNode>> entry : actualDataNodes.entrySet()) {
            for (DataNode each : entry.getValue()) {
                Map groupedDataNodesMap = result.computeIfAbsent(each.getDataSourceName(), k -> new LinkedHashMap());
                groupedDataNodesMap.computeIfAbsent(entry.getKey(), k -> new LinkedList()).add(each);
            }
        }
        return result;
    }

    private static String getLogicTables(Set<String> logicTables) {
        return Joiner.on((char)',').join(logicTables);
    }

    private static String getTablesFirstDataNodes(Map<String, List<DataNode>> actualDataNodes) {
        ArrayList<JobDataNodeEntry> dataNodeEntries = new ArrayList<JobDataNodeEntry>(actualDataNodes.size());
        for (Map.Entry<String, List<DataNode>> entry : actualDataNodes.entrySet()) {
            dataNodeEntries.add(new JobDataNodeEntry(entry.getKey(), entry.getValue().subList(0, 1)));
        }
        return new JobDataNodeLine(dataNodeEntries).marshal();
    }

    public TaskConfiguration createTaskConfiguration(PipelineConfiguration pipelineConfig, HandleConfiguration handleConfig, OnRuleAlteredActionConfiguration onRuleAlteredActionConfig) {
        ShardingSpherePipelineDataSourceConfiguration sourceConfig = ShardingRuleAlteredJobConfigurationPreparer.getSourceConfiguration(pipelineConfig);
        ShardingRuleConfiguration sourceRuleConfig = ShardingRuleConfigurationConverter.findAndConvertShardingRuleConfiguration(sourceConfig.getRootConfig().getRules());
        Map dataSourcePropsMap = new YamlDataSourceConfigurationSwapper().getDataSourcePropertiesMap(sourceConfig.getRootConfig());
        JobDataNodeLine dataNodeLine = JobDataNodeLine.unmarshal((String)((String)handleConfig.getJobShardingDataNodes().get(handleConfig.getJobShardingItem())));
        String dataSourceName = ((DataNode)((JobDataNodeEntry)dataNodeLine.getEntries().get(0)).getDataNodes().get(0)).getDataSourceName();
        LinkedHashMap<String, String> tableMap = new LinkedHashMap<String, String>();
        for (JobDataNodeEntry each : dataNodeLine.getEntries()) {
            for (DataNode dataNode : each.getDataNodes()) {
                tableMap.put(dataNode.getTableName(), each.getLogicTableName());
            }
        }
        DumperConfiguration dumperConfig = ShardingRuleAlteredJobConfigurationPreparer.createDumperConfig(dataSourceName, ((DataSourceProperties)dataSourcePropsMap.get(dataSourceName)).getAllLocalProperties(), tableMap);
        Optional<ShardingRuleConfiguration> targetRuleConfigOptional = ShardingRuleAlteredJobConfigurationPreparer.getTargetRuleConfiguration(pipelineConfig);
        Map<String, Set<String>> shardingColumnsMap = ShardingRuleAlteredJobConfigurationPreparer.getShardingColumnsMap(targetRuleConfigOptional.orElse(sourceRuleConfig), new HashSet<String>(handleConfig.splitLogicTableNames()));
        ImporterConfiguration importerConfig = ShardingRuleAlteredJobConfigurationPreparer.createImporterConfig(pipelineConfig, handleConfig, onRuleAlteredActionConfig, shardingColumnsMap);
        TaskConfiguration result = new TaskConfiguration(handleConfig, dumperConfig, importerConfig);
        log.info("createTaskConfiguration, dataSourceName={}, result={}", (Object)dataSourceName, (Object)result);
        return result;
    }

    private static ShardingSpherePipelineDataSourceConfiguration getSourceConfiguration(PipelineConfiguration pipelineConfig) {
        PipelineDataSourceConfiguration result = PipelineDataSourceConfigurationFactory.newInstance((String)pipelineConfig.getSource().getType(), (String)pipelineConfig.getSource().getParameter());
        return (ShardingSpherePipelineDataSourceConfiguration)result;
    }

    private static Optional<ShardingRuleConfiguration> getTargetRuleConfiguration(PipelineConfiguration pipelineConfig) {
        PipelineDataSourceConfiguration targetDataSourceConfig = PipelineDataSourceConfigurationFactory.newInstance((String)pipelineConfig.getTarget().getType(), (String)pipelineConfig.getTarget().getParameter());
        if (!(targetDataSourceConfig instanceof ShardingSpherePipelineDataSourceConfiguration)) {
            return Optional.empty();
        }
        ShardingSpherePipelineDataSourceConfiguration target = (ShardingSpherePipelineDataSourceConfiguration)targetDataSourceConfig;
        return Optional.of(ShardingRuleConfigurationConverter.findAndConvertShardingRuleConfiguration(target.getRootConfig().getRules()));
    }

    private static Map<String, Set<String>> getShardingColumnsMap(ShardingRuleConfiguration shardingRuleConfig, Set<String> reShardNeededTables) {
        Set<String> defaultDatabaseShardingColumns = ShardingRuleAlteredJobConfigurationPreparer.extractShardingColumns(shardingRuleConfig.getDefaultDatabaseShardingStrategy());
        Set<String> defaultTableShardingColumns = ShardingRuleAlteredJobConfigurationPreparer.extractShardingColumns(shardingRuleConfig.getDefaultTableShardingStrategy());
        ConcurrentMap result = Maps.newConcurrentMap();
        for (ShardingTableRuleConfiguration each : shardingRuleConfig.getTables()) {
            if (!reShardNeededTables.contains(each.getLogicTable())) continue;
            HashSet<String> shardingColumns = new HashSet<String>();
            shardingColumns.addAll(null == each.getDatabaseShardingStrategy() ? defaultDatabaseShardingColumns : ShardingRuleAlteredJobConfigurationPreparer.extractShardingColumns(each.getDatabaseShardingStrategy()));
            shardingColumns.addAll(null == each.getTableShardingStrategy() ? defaultTableShardingColumns : ShardingRuleAlteredJobConfigurationPreparer.extractShardingColumns(each.getTableShardingStrategy()));
            result.put(each.getLogicTable(), shardingColumns);
        }
        for (ShardingTableRuleConfiguration each : shardingRuleConfig.getAutoTables()) {
            if (!reShardNeededTables.contains(each.getLogicTable())) continue;
            ShardingStrategyConfiguration shardingStrategy = each.getShardingStrategy();
            HashSet<String> shardingColumns = new HashSet<String>(ShardingRuleAlteredJobConfigurationPreparer.extractShardingColumns(shardingStrategy));
            result.put(each.getLogicTable(), shardingColumns);
        }
        return result;
    }

    private static Set<String> extractShardingColumns(ShardingStrategyConfiguration shardingStrategy) {
        if (shardingStrategy instanceof StandardShardingStrategyConfiguration) {
            return Sets.newHashSet((Object[])new String[]{((StandardShardingStrategyConfiguration)shardingStrategy).getShardingColumn()});
        }
        if (shardingStrategy instanceof ComplexShardingStrategyConfiguration) {
            return Sets.newHashSet((Object[])((ComplexShardingStrategyConfiguration)shardingStrategy).getShardingColumns().split(","));
        }
        return Collections.emptySet();
    }

    private static DumperConfiguration createDumperConfig(String dataSourceName, Map<String, Object> props, Map<String, String> tableMap) {
        DumperConfiguration result = new DumperConfiguration();
        result.setDataSourceName(dataSourceName);
        result.setDataSourceConfig((PipelineDataSourceConfiguration)new StandardPipelineDataSourceConfiguration(YamlEngine.marshal(props)));
        result.setTableNameMap(tableMap);
        return result;
    }

    private static ImporterConfiguration createImporterConfig(PipelineConfiguration pipelineConfig, HandleConfiguration handleConfig, OnRuleAlteredActionConfiguration onRuleAlteredActionConfig, Map<String, Set<String>> shardingColumnsMap) {
        PipelineDataSourceConfiguration dataSourceConfig = PipelineDataSourceConfigurationFactory.newInstance((String)pipelineConfig.getTarget().getType(), (String)pipelineConfig.getTarget().getParameter());
        int batchSize = onRuleAlteredActionConfig.getOutput().getBatchSize();
        int retryTimes = handleConfig.getRetryTimes();
        return new ImporterConfiguration(dataSourceConfig, shardingColumnsMap, batchSize, retryTimes);
    }
}

