/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rule;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.config.TypedSPIConfiguration;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmFactory;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereInstanceRequiredAlgorithm;
import org.apache.shardingsphere.infra.config.exception.ShardingSphereConfigurationException;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rule.identifier.scope.SchemaRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.InstanceAwareRule;
import org.apache.shardingsphere.infra.rule.identifier.type.TableContainedRule;
import org.apache.shardingsphere.sharding.algorithm.config.AlgorithmProvidedShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ComplexShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.NoneShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.StandardShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.sharding.ShardingAutoTableAlgorithm;
import org.apache.shardingsphere.sharding.rule.BindingTableRule;
import org.apache.shardingsphere.sharding.rule.TableRule;
import org.apache.shardingsphere.sharding.spi.KeyGenerateAlgorithm;
import org.apache.shardingsphere.sharding.spi.ShardingAlgorithm;
import org.apache.shardingsphere.sharding.support.InlineExpressionParser;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.required.RequiredSPIRegistry;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.ExpressionExtractUtil;
import org.apache.shardingsphere.sql.parser.sql.common.util.WhereExtractUtil;

public final class ShardingRule
implements SchemaRule,
DataNodeContainedRule,
TableContainedRule,
InstanceAwareRule {
    private static final String EQUAL = "=";
    private final Collection<String> dataSourceNames;
    private final Map<String, ShardingAlgorithm> shardingAlgorithms = new LinkedHashMap<String, ShardingAlgorithm>();
    private final Map<String, KeyGenerateAlgorithm> keyGenerators = new LinkedHashMap<String, KeyGenerateAlgorithm>();
    private final Map<String, TableRule> tableRules = new LinkedHashMap<String, TableRule>();
    private final Map<String, BindingTableRule> bindingTableRules = new LinkedHashMap<String, BindingTableRule>();
    private final Collection<String> broadcastTables;
    private final ShardingStrategyConfiguration defaultDatabaseShardingStrategyConfig;
    private final ShardingStrategyConfiguration defaultTableShardingStrategyConfig;
    private final KeyGenerateAlgorithm defaultKeyGenerateAlgorithm;
    private final String defaultShardingColumn;
    private final Map<String, Collection<DataNode>> shardingTableDataNodes;

    public ShardingRule(ShardingRuleConfiguration config, Collection<String> dataSourceNames) {
        this.dataSourceNames = this.getDataSourceNames(config.getTables(), config.getAutoTables(), dataSourceNames);
        config.getShardingAlgorithms().forEach((key, value) -> this.shardingAlgorithms.put((String)key, (ShardingAlgorithm)ShardingSphereAlgorithmFactory.createAlgorithm((TypedSPIConfiguration)value, ShardingAlgorithm.class)));
        config.getKeyGenerators().forEach((key, value) -> this.keyGenerators.put((String)key, (KeyGenerateAlgorithm)ShardingSphereAlgorithmFactory.createAlgorithm((TypedSPIConfiguration)value, KeyGenerateAlgorithm.class)));
        this.tableRules.putAll(this.createTableRules(config.getTables(), config.getDefaultKeyGenerateStrategy()));
        this.tableRules.putAll(this.createAutoTableRules(config.getAutoTables(), config.getDefaultKeyGenerateStrategy()));
        this.bindingTableRules.putAll(this.createBindingTableRules(config.getBindingTableGroups()));
        this.broadcastTables = this.createBroadcastTables(config.getBroadcastTables());
        this.defaultDatabaseShardingStrategyConfig = null == config.getDefaultDatabaseShardingStrategy() ? new NoneShardingStrategyConfiguration() : config.getDefaultDatabaseShardingStrategy();
        this.defaultTableShardingStrategyConfig = null == config.getDefaultTableShardingStrategy() ? new NoneShardingStrategyConfiguration() : config.getDefaultTableShardingStrategy();
        this.defaultKeyGenerateAlgorithm = null == config.getDefaultKeyGenerateStrategy() ? (KeyGenerateAlgorithm)RequiredSPIRegistry.getRegisteredService(KeyGenerateAlgorithm.class) : this.keyGenerators.get(config.getDefaultKeyGenerateStrategy().getKeyGeneratorName());
        this.defaultShardingColumn = config.getDefaultShardingColumn();
        this.shardingTableDataNodes = this.createShardingTableDataNodes(this.tableRules);
        Preconditions.checkArgument((boolean)this.isValidBindingTableConfiguration(config.getBindingTableGroups()), (Object)"Invalid binding table configuration in ShardingRuleConfiguration.");
    }

    public ShardingRule(AlgorithmProvidedShardingRuleConfiguration config, Collection<String> dataSourceNames) {
        this.dataSourceNames = this.getDataSourceNames(config.getTables(), config.getAutoTables(), dataSourceNames);
        this.shardingAlgorithms.putAll(config.getShardingAlgorithms());
        this.keyGenerators.putAll(config.getKeyGenerators());
        this.tableRules.putAll(this.createTableRules(config.getTables(), config.getDefaultKeyGenerateStrategy()));
        this.tableRules.putAll(this.createAutoTableRules(config.getAutoTables(), config.getDefaultKeyGenerateStrategy()));
        this.bindingTableRules.putAll(this.createBindingTableRules(config.getBindingTableGroups()));
        this.broadcastTables = this.createBroadcastTables(config.getBroadcastTables());
        this.defaultDatabaseShardingStrategyConfig = null == config.getDefaultDatabaseShardingStrategy() ? new NoneShardingStrategyConfiguration() : config.getDefaultDatabaseShardingStrategy();
        this.defaultTableShardingStrategyConfig = null == config.getDefaultTableShardingStrategy() ? new NoneShardingStrategyConfiguration() : config.getDefaultTableShardingStrategy();
        this.defaultKeyGenerateAlgorithm = null == config.getDefaultKeyGenerateStrategy() ? (KeyGenerateAlgorithm)RequiredSPIRegistry.getRegisteredService(KeyGenerateAlgorithm.class) : this.keyGenerators.get(config.getDefaultKeyGenerateStrategy().getKeyGeneratorName());
        this.defaultShardingColumn = config.getDefaultShardingColumn();
        this.shardingTableDataNodes = this.createShardingTableDataNodes(this.tableRules);
        Preconditions.checkArgument((boolean)this.isValidBindingTableConfiguration(config.getBindingTableGroups()), (Object)"Invalid binding table configuration in ShardingRuleConfiguration.");
    }

    private Map<String, Collection<DataNode>> createShardingTableDataNodes(Map<String, TableRule> tableRules) {
        HashMap<String, Collection<DataNode>> result = new HashMap<String, Collection<DataNode>>(tableRules.size(), 1.0f);
        for (TableRule each : tableRules.values()) {
            result.put(each.getLogicTable().toLowerCase(), each.getActualDataNodes());
        }
        return result;
    }

    private Collection<String> getDataSourceNames(Collection<ShardingTableRuleConfiguration> tableRuleConfigs, Collection<ShardingAutoTableRuleConfiguration> autoTableRuleConfigs, Collection<String> dataSourceNames) {
        if (tableRuleConfigs.isEmpty() && autoTableRuleConfigs.isEmpty()) {
            return dataSourceNames;
        }
        if (tableRuleConfigs.stream().map(ShardingTableRuleConfiguration::getActualDataNodes).anyMatch(each -> null == each || each.isEmpty())) {
            return dataSourceNames;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        tableRuleConfigs.forEach(each -> result.addAll(this.getDataSourceNames((ShardingTableRuleConfiguration)each)));
        autoTableRuleConfigs.forEach(each -> result.addAll(this.getDataSourceNames((ShardingAutoTableRuleConfiguration)each)));
        return result;
    }

    private Collection<String> getDataSourceNames(ShardingAutoTableRuleConfiguration shardingAutoTableRuleConfig) {
        List actualDataSources = new InlineExpressionParser(shardingAutoTableRuleConfig.getActualDataSources()).splitAndEvaluate();
        return new HashSet<String>(actualDataSources);
    }

    private Collection<String> getDataSourceNames(ShardingTableRuleConfiguration shardingTableRuleConfig) {
        List actualDataNodes = new InlineExpressionParser(shardingTableRuleConfig.getActualDataNodes()).splitAndEvaluate();
        return actualDataNodes.stream().map(each -> new DataNode(each).getDataSourceName()).collect(Collectors.toList());
    }

    private Map<String, TableRule> createTableRules(Collection<ShardingTableRuleConfiguration> tableRuleConfigs, KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig) {
        return tableRuleConfigs.stream().map(each -> new TableRule((ShardingTableRuleConfiguration)each, this.dataSourceNames, this.getDefaultGenerateKeyColumn(defaultKeyGenerateStrategyConfig))).collect(Collectors.toMap(each -> each.getLogicTable().toLowerCase(), Function.identity(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private Map<String, TableRule> createAutoTableRules(Collection<ShardingAutoTableRuleConfiguration> autoTableRuleConfigs, KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig) {
        return autoTableRuleConfigs.stream().map(each -> this.createAutoTableRule(defaultKeyGenerateStrategyConfig, (ShardingAutoTableRuleConfiguration)each)).collect(Collectors.toMap(each -> each.getLogicTable().toLowerCase(), Function.identity(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private TableRule createAutoTableRule(KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig, ShardingAutoTableRuleConfiguration autoTableRuleConfig) {
        ShardingAlgorithm shardingAlgorithm = null == autoTableRuleConfig.getShardingStrategy() ? null : this.shardingAlgorithms.get(autoTableRuleConfig.getShardingStrategy().getShardingAlgorithmName());
        Preconditions.checkState((boolean)(shardingAlgorithm instanceof ShardingAutoTableAlgorithm), (Object)"Sharding auto table rule configuration must match sharding auto table algorithm.");
        return new TableRule(autoTableRuleConfig, this.dataSourceNames, (ShardingAutoTableAlgorithm)shardingAlgorithm, this.getDefaultGenerateKeyColumn(defaultKeyGenerateStrategyConfig));
    }

    private String getDefaultGenerateKeyColumn(KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig) {
        return Optional.ofNullable(defaultKeyGenerateStrategyConfig).map(KeyGenerateStrategyConfiguration::getColumn).orElse(null);
    }

    private Collection<String> createBroadcastTables(Collection<String> broadcastTables) {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.addAll(broadcastTables);
        return result;
    }

    private Map<String, BindingTableRule> createBindingTableRules(Collection<String> bindingTableGroups) {
        LinkedHashMap<String, BindingTableRule> result = new LinkedHashMap<String, BindingTableRule>();
        for (String each : bindingTableGroups) {
            BindingTableRule bindingTableRule = this.createBindingTableRule(each);
            for (String logicTable : bindingTableRule.getAllLogicTables()) {
                result.put(logicTable.toLowerCase(), bindingTableRule);
            }
        }
        return result;
    }

    private BindingTableRule createBindingTableRule(String bindingTableGroup) {
        Map tableRules = Splitter.on((String)",").trimResults().splitToList((CharSequence)bindingTableGroup).stream().map(this::getTableRule).collect(Collectors.toMap(each -> each.getLogicTable().toLowerCase(), Function.identity(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
        BindingTableRule result = new BindingTableRule();
        result.getTableRules().putAll(tableRules);
        return result;
    }

    private boolean isValidBindingTableConfiguration(Collection<String> bindingTableGroups) {
        for (String each : bindingTableGroups) {
            List bindingTables = Splitter.on((String)",").trimResults().splitToList((CharSequence)each.toLowerCase());
            if (bindingTables.size() <= 1) continue;
            Iterator iterator = bindingTables.iterator();
            TableRule sampleTableRule = this.getTableRule((String)iterator.next());
            while (iterator.hasNext()) {
                TableRule tableRule = this.getTableRule((String)iterator.next());
                if (!this.isValidActualDatasourceName(sampleTableRule, tableRule) || !this.isValidActualTableName(sampleTableRule, tableRule)) {
                    return false;
                }
                if (this.isValidShardingAlgorithm(sampleTableRule, tableRule, true) && this.isValidShardingAlgorithm(sampleTableRule, tableRule, false)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isValidActualDatasourceName(TableRule sampleTableRule, TableRule tableRule) {
        return sampleTableRule.getActualDatasourceNames().equals(tableRule.getActualDatasourceNames());
    }

    private boolean isValidActualTableName(TableRule sampleTableRule, TableRule tableRule) {
        for (String each : sampleTableRule.getActualDatasourceNames()) {
            Collection actualTableNames;
            Collection sampleActualTableNames = sampleTableRule.getActualTableNames(each).stream().map(actualTableName -> actualTableName.replace(sampleTableRule.getTableDataNode().getPrefix(), "")).collect(Collectors.toSet());
            if (sampleActualTableNames.equals(actualTableNames = (Collection)tableRule.getActualTableNames(each).stream().map(actualTableName -> actualTableName.replace(tableRule.getTableDataNode().getPrefix(), "")).collect(Collectors.toSet()))) continue;
            return false;
        }
        return true;
    }

    private boolean isValidShardingAlgorithm(TableRule sampleTableRule, TableRule tableRule, boolean databaseAlgorithm) {
        String sampleAlgorithmExpression = this.getAlgorithmExpression(sampleTableRule, databaseAlgorithm);
        String algorithmExpression = this.getAlgorithmExpression(tableRule, databaseAlgorithm);
        return sampleAlgorithmExpression.equalsIgnoreCase(algorithmExpression);
    }

    private String getAlgorithmExpression(TableRule tableRule, boolean databaseAlgorithm) {
        ShardingStrategyConfiguration shardingStrategyConfig = databaseAlgorithm ? (null == tableRule.getDatabaseShardingStrategyConfig() ? this.defaultDatabaseShardingStrategyConfig : tableRule.getDatabaseShardingStrategyConfig()) : (null == tableRule.getTableShardingStrategyConfig() ? this.defaultTableShardingStrategyConfig : tableRule.getTableShardingStrategyConfig());
        ShardingAlgorithm shardingAlgorithm = this.shardingAlgorithms.get(shardingStrategyConfig.getShardingAlgorithmName());
        String originAlgorithmExpression = null == shardingAlgorithm ? "" : StringUtils.defaultString((String)shardingAlgorithm.getProps().getProperty("algorithm-expression"), (String)"");
        String sampleDataNodePrefix = databaseAlgorithm ? tableRule.getDataSourceDataNode().getPrefix() : tableRule.getTableDataNode().getPrefix();
        String shardingColumn = this.getShardingColumn(shardingStrategyConfig);
        return originAlgorithmExpression.replace(sampleDataNodePrefix, "").replace(shardingColumn, "");
    }

    private String getShardingColumn(ShardingStrategyConfiguration shardingStrategyConfig) {
        if (shardingStrategyConfig instanceof ComplexShardingStrategyConfiguration) {
            return ((ComplexShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumns();
        }
        if (shardingStrategyConfig instanceof StandardShardingStrategyConfiguration) {
            return ((StandardShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumn();
        }
        return StringUtils.defaultString((String)this.defaultShardingColumn, (String)"");
    }

    public Collection<String> getAllTables() {
        HashSet<String> result = new HashSet<String>(this.getTables());
        result.addAll(this.getAllActualTables());
        return result;
    }

    public ShardingStrategyConfiguration getDatabaseShardingStrategyConfiguration(TableRule tableRule) {
        return null == tableRule.getDatabaseShardingStrategyConfig() ? this.defaultDatabaseShardingStrategyConfig : tableRule.getDatabaseShardingStrategyConfig();
    }

    public ShardingStrategyConfiguration getTableShardingStrategyConfiguration(TableRule tableRule) {
        return null == tableRule.getTableShardingStrategyConfig() ? this.defaultTableShardingStrategyConfig : tableRule.getTableShardingStrategyConfig();
    }

    public Optional<TableRule> findTableRule(String logicTableName) {
        return Optional.ofNullable(this.tableRules.get(logicTableName.toLowerCase()));
    }

    public Optional<TableRule> findTableRuleByActualTable(String actualTableName) {
        for (TableRule each : this.tableRules.values()) {
            if (!each.isExisted(actualTableName)) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    public TableRule getTableRule(String logicTableName) {
        Optional<TableRule> tableRule = this.findTableRule(logicTableName);
        if (tableRule.isPresent()) {
            return tableRule.get();
        }
        if (this.isBroadcastTable(logicTableName)) {
            return new TableRule(this.dataSourceNames, logicTableName);
        }
        throw new ShardingSphereConfigurationException("Cannot find table rule with logic table: '%s'", new Object[]{logicTableName});
    }

    public boolean isAllBindingTables(Collection<String> logicTableNames) {
        if (logicTableNames.isEmpty()) {
            return false;
        }
        Optional<BindingTableRule> bindingTableRule = this.findBindingTableRule(logicTableNames);
        if (!bindingTableRule.isPresent()) {
            return false;
        }
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.addAll(bindingTableRule.get().getAllLogicTables());
        return !result.isEmpty() && result.containsAll(logicTableNames);
    }

    public boolean isAllBindingTables(ShardingSphereSchema schema, SQLStatementContext<?> sqlStatementContext, Collection<String> logicTableNames) {
        if (!(sqlStatementContext instanceof SelectStatementContext) || !((SelectStatementContext)sqlStatementContext).isContainsJoinQuery()) {
            return this.isAllBindingTables(logicTableNames);
        }
        if (!this.isAllBindingTables(logicTableNames)) {
            return false;
        }
        SelectStatementContext select = (SelectStatementContext)sqlStatementContext;
        Collection joinSegments = WhereExtractUtil.getJoinWhereSegments((SelectStatement)((SelectStatement)select.getSqlStatement()));
        return this.isJoinConditionContainsShardingColumns(schema, select, logicTableNames, joinSegments) || this.isJoinConditionContainsShardingColumns(schema, select, logicTableNames, select.getWhereSegments());
    }

    private Optional<BindingTableRule> findBindingTableRule(Collection<String> logicTableNames) {
        for (String each : logicTableNames) {
            Optional<BindingTableRule> result = this.findBindingTableRule(each);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    public Optional<BindingTableRule> findBindingTableRule(String logicTableName) {
        return Optional.ofNullable(this.bindingTableRules.get(logicTableName.toLowerCase()));
    }

    public boolean isAllBroadcastTables(Collection<String> logicTableNames) {
        return !logicTableNames.isEmpty() && this.broadcastTables.containsAll(logicTableNames);
    }

    public boolean isAllShardingTables(Collection<String> logicTableNames) {
        if (logicTableNames.isEmpty()) {
            return false;
        }
        for (String each : logicTableNames) {
            if (this.isShardingTable(each)) continue;
            return false;
        }
        return true;
    }

    public boolean isShardingTable(String logicTableName) {
        return this.tableRules.containsKey(logicTableName.toLowerCase());
    }

    public boolean isBroadcastTable(String logicTableName) {
        return this.broadcastTables.contains(logicTableName);
    }

    public boolean isAllTablesInSameDataSource(Collection<String> logicTableNames) {
        Collection dataSourceNames = logicTableNames.stream().map(each -> this.tableRules.get(each.toLowerCase())).filter(Objects::nonNull).flatMap(each -> each.getActualDatasourceNames().stream()).collect(Collectors.toSet());
        return 1 == dataSourceNames.size();
    }

    public boolean tableRuleExists(Collection<String> logicTableNames) {
        for (String each : logicTableNames) {
            if (!this.isShardingTable(each) && !this.isBroadcastTable(each)) continue;
            return true;
        }
        return false;
    }

    public Optional<String> findShardingColumn(String columnName, String tableName) {
        return Optional.ofNullable(this.tableRules.get(tableName.toLowerCase())).flatMap(optional -> this.findShardingColumn((TableRule)optional, columnName));
    }

    private Optional<String> findShardingColumn(TableRule tableRule, String columnName) {
        Optional<String> databaseShardingColumn = this.findShardingColumn(this.getDatabaseShardingStrategyConfiguration(tableRule), columnName);
        if (databaseShardingColumn.isPresent()) {
            return databaseShardingColumn;
        }
        return this.findShardingColumn(this.getTableShardingStrategyConfiguration(tableRule), columnName);
    }

    private Optional<String> findShardingColumn(ShardingStrategyConfiguration shardingStrategyConfig, String columnName) {
        if (shardingStrategyConfig instanceof StandardShardingStrategyConfiguration) {
            String shardingColumn = null == ((StandardShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumn() ? this.defaultShardingColumn : ((StandardShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumn();
            return shardingColumn.equalsIgnoreCase(columnName) ? Optional.of(shardingColumn) : Optional.empty();
        }
        if (shardingStrategyConfig instanceof ComplexShardingStrategyConfiguration) {
            List shardingColumns = Splitter.on((String)",").trimResults().splitToList((CharSequence)((ComplexShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumns());
            for (String each : shardingColumns) {
                if (!each.equalsIgnoreCase(columnName)) continue;
                return Optional.of(each);
            }
        }
        return Optional.empty();
    }

    public boolean isGenerateKeyColumn(String columnName, String tableName) {
        return Optional.ofNullable(this.tableRules.get(tableName.toLowerCase())).filter(each -> this.isGenerateKeyColumn((TableRule)each, columnName)).isPresent();
    }

    private boolean isGenerateKeyColumn(TableRule tableRule, String columnName) {
        Optional<String> generateKeyColumn = tableRule.getGenerateKeyColumn();
        return generateKeyColumn.isPresent() && generateKeyColumn.get().equalsIgnoreCase(columnName);
    }

    public Optional<String> findGenerateKeyColumnName(String logicTableName) {
        return Optional.ofNullable(this.tableRules.get(logicTableName.toLowerCase())).filter(each -> each.getGenerateKeyColumn().isPresent()).flatMap(TableRule::getGenerateKeyColumn);
    }

    public Comparable<?> generateKey(String logicTableName) {
        Optional<TableRule> tableRule = this.findTableRule(logicTableName);
        if (!tableRule.isPresent()) {
            throw new ShardingSphereConfigurationException("Cannot find strategy for generate keys.", new Object[0]);
        }
        KeyGenerateAlgorithm keyGenerator = null != tableRule.get().getKeyGeneratorName() ? this.keyGenerators.get(tableRule.get().getKeyGeneratorName()) : this.defaultKeyGenerateAlgorithm;
        return keyGenerator.generateKey();
    }

    public DataNode getDataNode(String logicTableName) {
        TableRule tableRule = this.getTableRule(logicTableName);
        return tableRule.getActualDataNodes().get(0);
    }

    public Collection<String> getShardingLogicTableNames(Collection<String> logicTableNames) {
        LinkedList<String> result = new LinkedList<String>();
        for (String each : logicTableNames) {
            if (!this.isShardingTable(each)) continue;
            result.add(each);
        }
        return result;
    }

    public Collection<String> getShardingRuleTableNames(Collection<String> logicTableNames) {
        return logicTableNames.stream().filter(each -> this.isShardingTable((String)each) || this.isBroadcastTable((String)each)).collect(Collectors.toCollection(LinkedList::new));
    }

    public Map<String, String> getLogicAndActualTablesFromBindingTable(String dataSourceName, String logicTable, String actualTable, Collection<String> availableLogicBindingTables) {
        return this.findBindingTableRule(logicTable).map(optional -> optional.getLogicAndActualTables(dataSourceName, logicTable, actualTable, availableLogicBindingTables)).orElseGet(Collections::emptyMap);
    }

    public Collection<String> getLogicTablesByActualTable(String actualTable) {
        return this.tableRules.values().stream().filter(each -> each.isExisted(actualTable)).map(TableRule::getLogicTable).collect(Collectors.toSet());
    }

    public Map<String, Collection<DataNode>> getAllDataNodes() {
        return this.shardingTableDataNodes;
    }

    public Collection<DataNode> getDataNodesByTableName(String tableName) {
        return this.shardingTableDataNodes.getOrDefault(tableName.toLowerCase(), Collections.emptyList());
    }

    private Collection<String> getAllActualTables() {
        return this.tableRules.values().stream().flatMap(each -> each.getActualDataNodes().stream().map(DataNode::getTableName)).collect(Collectors.toSet());
    }

    public Optional<String> findFirstActualTable(String logicTable) {
        return this.findTableRule(logicTable).map(tableRule -> tableRule.getActualDataNodes().get(0).getTableName());
    }

    public boolean isNeedAccumulate(Collection<String> tables) {
        return !this.isAllBroadcastTables(tables);
    }

    public Optional<String> findLogicTableByActualTable(String actualTable) {
        return this.findTableRuleByActualTable(actualTable).map(TableRule::getLogicTable);
    }

    public Collection<String> getTables() {
        Collection result = this.tableRules.values().stream().map(TableRule::getLogicTable).collect(Collectors.toSet());
        result.addAll(this.broadcastTables);
        return result;
    }

    public Optional<String> findActualTableByCatalog(String catalog, String logicTable) {
        return this.findTableRule(logicTable).flatMap(tableRule -> this.findActualTableFromActualDataNode(catalog, tableRule.getActualDataNodes()));
    }

    private Optional<String> findActualTableFromActualDataNode(String catalog, List<DataNode> actualDataNodes) {
        return actualDataNodes.stream().filter(each -> each.getDataSourceName().equalsIgnoreCase(catalog)).findFirst().map(DataNode::getTableName);
    }

    public String getType() {
        return ShardingRule.class.getSimpleName();
    }

    private boolean isJoinConditionContainsShardingColumns(ShardingSphereSchema schema, SelectStatementContext select, Collection<String> tableNames, Collection<WhereSegment> whereSegments) {
        HashSet<String> databaseJoinConditionTables = new HashSet<String>(tableNames.size());
        HashSet<String> tableJoinConditionTables = new HashSet<String>(tableNames.size());
        for (WhereSegment each : whereSegments) {
            Collection andPredicates = ExpressionExtractUtil.getAndPredicates((ExpressionSegment)each.getExpr());
            if (andPredicates.size() > 1) {
                return false;
            }
            for (AndPredicate andPredicate : andPredicates) {
                databaseJoinConditionTables.addAll(this.getJoinConditionTables(schema, select, andPredicate.getPredicates(), true));
                tableJoinConditionTables.addAll(this.getJoinConditionTables(schema, select, andPredicate.getPredicates(), false));
            }
        }
        TableRule tableRule = this.getTableRule(tableNames.iterator().next());
        boolean containsDatabaseShardingColumns = !(this.getDatabaseShardingStrategyConfiguration(tableRule) instanceof StandardShardingStrategyConfiguration) || databaseJoinConditionTables.containsAll(tableNames);
        boolean containsTableShardingColumns = !(this.getTableShardingStrategyConfiguration(tableRule) instanceof StandardShardingStrategyConfiguration) || tableJoinConditionTables.containsAll(tableNames);
        return containsDatabaseShardingColumns && containsTableShardingColumns;
    }

    private Collection<String> getJoinConditionTables(ShardingSphereSchema schema, SelectStatementContext select, Collection<ExpressionSegment> predicates, boolean isDatabaseJoinCondition) {
        LinkedList<String> result = new LinkedList<String>();
        for (ExpressionSegment each : predicates) {
            ShardingStrategyConfiguration rightConfiguration;
            if (!this.isJoinConditionExpression(each)) continue;
            ColumnSegment leftColumn = (ColumnSegment)((BinaryOperationExpression)each).getLeft();
            ColumnSegment rightColumn = (ColumnSegment)((BinaryOperationExpression)each).getRight();
            Map columnExpressionTableNames = select.getTablesContext().findTableNamesByColumnSegment(Arrays.asList(leftColumn, rightColumn), schema);
            Optional<TableRule> leftTableRule = this.findTableRule((String)columnExpressionTableNames.get(leftColumn.getExpression()));
            Optional<TableRule> rightTableRule = this.findTableRule((String)columnExpressionTableNames.get(rightColumn.getExpression()));
            if (!leftTableRule.isPresent() || !rightTableRule.isPresent()) continue;
            ShardingStrategyConfiguration leftConfiguration = isDatabaseJoinCondition ? this.getDatabaseShardingStrategyConfiguration(leftTableRule.get()) : this.getTableShardingStrategyConfiguration(leftTableRule.get());
            ShardingStrategyConfiguration shardingStrategyConfiguration = rightConfiguration = isDatabaseJoinCondition ? this.getDatabaseShardingStrategyConfiguration(rightTableRule.get()) : this.getTableShardingStrategyConfiguration(rightTableRule.get());
            if (!this.findShardingColumn(leftConfiguration, leftColumn.getIdentifier().getValue()).isPresent() || !this.findShardingColumn(rightConfiguration, rightColumn.getIdentifier().getValue()).isPresent()) continue;
            result.add((String)columnExpressionTableNames.get(leftColumn.getExpression()));
            result.add((String)columnExpressionTableNames.get(rightColumn.getExpression()));
        }
        return result;
    }

    private boolean isJoinConditionExpression(ExpressionSegment expression) {
        if (!(expression instanceof BinaryOperationExpression)) {
            return false;
        }
        BinaryOperationExpression binaryExpression = (BinaryOperationExpression)expression;
        return binaryExpression.getLeft() instanceof ColumnSegment && binaryExpression.getRight() instanceof ColumnSegment && EQUAL.equals(binaryExpression.getOperator());
    }

    public void setInstanceContext(InstanceContext instanceContext) {
        this.keyGenerators.values().stream().filter(each -> each instanceof ShardingSphereInstanceRequiredAlgorithm).forEach(each -> ((ShardingSphereInstanceRequiredAlgorithm)each).setInstanceContext(instanceContext));
        if (this.defaultKeyGenerateAlgorithm instanceof ShardingSphereInstanceRequiredAlgorithm) {
            ((ShardingSphereInstanceRequiredAlgorithm)this.defaultKeyGenerateAlgorithm).setInstanceContext(instanceContext);
        }
    }

    @Generated
    public Collection<String> getDataSourceNames() {
        return this.dataSourceNames;
    }

    @Generated
    public Map<String, ShardingAlgorithm> getShardingAlgorithms() {
        return this.shardingAlgorithms;
    }

    @Generated
    public Map<String, KeyGenerateAlgorithm> getKeyGenerators() {
        return this.keyGenerators;
    }

    @Generated
    public Map<String, TableRule> getTableRules() {
        return this.tableRules;
    }

    @Generated
    public Map<String, BindingTableRule> getBindingTableRules() {
        return this.bindingTableRules;
    }

    @Generated
    public Collection<String> getBroadcastTables() {
        return this.broadcastTables;
    }

    @Generated
    public ShardingStrategyConfiguration getDefaultDatabaseShardingStrategyConfig() {
        return this.defaultDatabaseShardingStrategyConfig;
    }

    @Generated
    public ShardingStrategyConfiguration getDefaultTableShardingStrategyConfig() {
        return this.defaultTableShardingStrategyConfig;
    }

    @Generated
    public KeyGenerateAlgorithm getDefaultKeyGenerateAlgorithm() {
        return this.defaultKeyGenerateAlgorithm;
    }

    @Generated
    public String getDefaultShardingColumn() {
        return this.defaultShardingColumn;
    }

    @Generated
    public Map<String, Collection<DataNode>> getShardingTableDataNodes() {
        return this.shardingTableDataNodes;
    }

    static {
        ShardingSphereServiceLoader.register(ShardingAlgorithm.class);
        ShardingSphereServiceLoader.register(KeyGenerateAlgorithm.class);
    }
}

