/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.ddl;

import java.util.Collection;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.route.engine.exception.NoSuchTableException;
import org.apache.shardingsphere.sharding.route.engine.exception.TableExistsException;
import org.apache.shardingsphere.sharding.route.engine.validator.ShardingStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DDLStatement;

public abstract class ShardingDDLStatementValidator<T extends DDLStatement>
implements ShardingStatementValidator<T> {
    protected void validateShardingTable(ShardingRule shardingRule, Collection<SimpleTableSegment> tables) {
        for (SimpleTableSegment each : tables) {
            String tableName = each.getTableName().getIdentifier().getValue();
            if (!shardingRule.isShardingTable(tableName)) continue;
            throw new ShardingSphereException("Can not support sharding table '%s'.", new Object[]{tableName});
        }
    }

    protected void validateTableExist(ShardingSphereSchema schema, Collection<SimpleTableSegment> tables) {
        for (SimpleTableSegment each : tables) {
            String tableName = each.getTableName().getIdentifier().getValue();
            if (schema.containsTable(tableName)) continue;
            throw new NoSuchTableException(tableName);
        }
    }

    protected void validateTableNotExist(ShardingSphereSchema schema, Collection<SimpleTableSegment> tables) {
        for (SimpleTableSegment each : tables) {
            String tableName = each.getTableName().getIdentifier().getValue();
            if (!schema.containsTable(tableName)) continue;
            throw new TableExistsException(tableName);
        }
    }

    protected boolean isRouteUnitDataNodeDifferentSize(ShardingRule shardingRule, RouteContext routeContext, String tableName) {
        return (shardingRule.isShardingTable(tableName) || shardingRule.isBroadcastTable(tableName)) && shardingRule.getTableRule(tableName).getActualDataNodes().size() != routeContext.getRouteUnits().size();
    }

    protected boolean isSchemaContainsIndex(ShardingSphereSchema schema, IndexSegment index) {
        return schema.getAllTableNames().stream().anyMatch(each -> schema.get(each).getIndexes().containsKey(index.getIdentifier().getValue()));
    }
}

