/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.type.complex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingConditions;
import org.apache.shardingsphere.sharding.route.engine.type.ShardingRouteEngine;
import org.apache.shardingsphere.sharding.route.engine.type.complex.ShardingCartesianRoutingEngine;
import org.apache.shardingsphere.sharding.route.engine.type.standard.ShardingStandardRoutingEngine;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.TableRule;

public final class ShardingComplexRoutingEngine
implements ShardingRouteEngine {
    private final ShardingConditions shardingConditions;
    private final ConfigurationProperties props;
    private final Collection<String> logicTables;

    @Override
    public RouteContext route(ShardingRule shardingRule) {
        RouteContext result = new RouteContext();
        TreeSet bindingTableNames = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        ArrayList<RouteContext> routeContexts = new ArrayList<RouteContext>(this.logicTables.size());
        for (String each : this.logicTables) {
            Optional<TableRule> tableRule = shardingRule.findTableRule(each);
            if (!tableRule.isPresent()) continue;
            if (!bindingTableNames.contains(each)) {
                routeContexts.add(new ShardingStandardRoutingEngine(tableRule.get().getLogicTable(), this.shardingConditions, this.props).route(shardingRule));
            }
            shardingRule.findBindingTableRule(each).ifPresent(bindingTableRule -> bindingTableNames.addAll(bindingTableRule.getTableRules().keySet()));
        }
        if (routeContexts.isEmpty()) {
            throw new ShardingSphereException("Cannot find table rule and default data source with logic tables: '%s'", new Object[]{this.logicTables});
        }
        if (1 == routeContexts.size()) {
            RouteContext newRouteContext = (RouteContext)routeContexts.iterator().next();
            result.getOriginalDataNodes().addAll(newRouteContext.getOriginalDataNodes());
            result.getRouteUnits().addAll(newRouteContext.getRouteUnits());
        } else {
            RouteContext routeContext = new ShardingCartesianRoutingEngine(routeContexts).route(shardingRule);
            result.getOriginalDataNodes().addAll(routeContext.getOriginalDataNodes());
            result.getRouteUnits().addAll(routeContext.getRouteUnits());
        }
        return result;
    }

    @Generated
    public ShardingComplexRoutingEngine(ShardingConditions shardingConditions, ConfigurationProperties props, Collection<String> logicTables) {
        this.shardingConditions = shardingConditions;
        this.props = props;
        this.logicTables = logicTables;
    }
}

