/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.pojo;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.RouteUnitAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.Substitutable;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class ConstraintToken
extends SQLToken
implements Substitutable,
RouteUnitAware {
    private final int stopIndex;
    private final IdentifierValue identifier;
    private final SQLStatementContext<?> sqlStatementContext;
    private final ShardingRule shardingRule;

    public ConstraintToken(int startIndex, int stopIndex, IdentifierValue identifier, SQLStatementContext<?> sqlStatementContext, ShardingRule shardingRule) {
        super(startIndex);
        this.stopIndex = stopIndex;
        this.identifier = identifier;
        this.sqlStatementContext = sqlStatementContext;
        this.shardingRule = shardingRule;
    }

    public String toString(RouteUnit routeUnit) {
        return this.identifier.getQuoteCharacter().wrap(this.getConstraintValue(routeUnit));
    }

    private String getConstraintValue(RouteUnit routeUnit) {
        StringBuilder result = new StringBuilder(this.identifier.getValue());
        Map<String, String> logicAndActualTables = this.getLogicAndActualTables(routeUnit);
        this.sqlStatementContext.getTablesContext().getTableNames().stream().findFirst().map(logicAndActualTables::get).ifPresent(tableName -> result.append("_").append((String)tableName));
        return result.toString();
    }

    private Map<String, String> getLogicAndActualTables(RouteUnit routeUnit) {
        Collection tableNames = this.sqlStatementContext.getTablesContext().getTableNames();
        HashMap<String, String> result = new HashMap<String, String>(tableNames.size(), 1.0f);
        for (RouteMapper each : routeUnit.getTableMappers()) {
            result.put(each.getLogicName().toLowerCase(), each.getActualName());
            result.putAll(this.shardingRule.getLogicAndActualTablesFromBindingTable(routeUnit.getDataSourceMapper().getLogicName(), each.getLogicName(), each.getActualName(), tableNames));
        }
        return result;
    }

    @Generated
    public int getStopIndex() {
        return this.stopIndex;
    }
}

