/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.generator.impl;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.IndexAvailable;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.SchemaMetaDataAware;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.IndexToken;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.aware.ShardingRuleAware;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;

public final class IndexTokenGenerator
implements CollectionSQLTokenGenerator<SQLStatementContext<?>>,
ShardingRuleAware,
SchemaMetaDataAware {
    private ShardingRule shardingRule;
    private ShardingSphereSchema schema;

    public boolean isGenerateSQLToken(SQLStatementContext<?> sqlStatementContext) {
        return sqlStatementContext instanceof IndexAvailable && !((IndexAvailable)sqlStatementContext).getIndexes().isEmpty();
    }

    public Collection<IndexToken> generateSQLTokens(SQLStatementContext<?> sqlStatementContext) {
        LinkedList<IndexToken> result = new LinkedList<IndexToken>();
        if (sqlStatementContext instanceof IndexAvailable) {
            for (IndexSegment each : ((IndexAvailable)sqlStatementContext).getIndexes()) {
                result.add(new IndexToken(each.getStartIndex(), each.getStopIndex(), each.getIdentifier(), sqlStatementContext, this.shardingRule, this.schema));
            }
        }
        return result;
    }

    @Override
    @Generated
    public void setShardingRule(ShardingRule shardingRule) {
        this.shardingRule = shardingRule;
    }

    @Generated
    public void setSchema(ShardingSphereSchema schema) {
        this.schema = schema;
    }
}

