/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge;

import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.merge.engine.merger.ResultMerger;
import org.apache.shardingsphere.infra.merge.engine.merger.ResultMergerEngine;
import org.apache.shardingsphere.infra.merge.engine.merger.impl.TransparentResultMerger;
import org.apache.shardingsphere.sharding.merge.dal.ShardingDALResultMerger;
import org.apache.shardingsphere.sharding.merge.dql.ShardingDQLResultMerger;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.DALStatement;

public final class ShardingResultMergerEngine
implements ResultMergerEngine<ShardingRule> {
    public ResultMerger newInstance(String schemaName, DatabaseType databaseType, ShardingRule shardingRule, ConfigurationProperties props, SQLStatementContext<?> sqlStatementContext) {
        if (sqlStatementContext instanceof SelectStatementContext) {
            return new ShardingDQLResultMerger(databaseType);
        }
        if (sqlStatementContext.getSqlStatement() instanceof DALStatement) {
            return new ShardingDALResultMerger(schemaName, shardingRule);
        }
        return new TransparentResultMerger();
    }

    public int getOrder() {
        return -10;
    }

    public Class<ShardingRule> getTypeClass() {
        return ShardingRule.class;
    }
}

