/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.range;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.common.math.LongMath;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.shardingsphere.sharding.algorithm.sharding.range.AbstractRangeShardingAlgorithm;

public final class VolumeBasedRangeShardingAlgorithm
extends AbstractRangeShardingAlgorithm {
    private static final String RANGE_LOWER_KEY = "range-lower";
    private static final String RANGE_UPPER_KEY = "range-upper";
    private static final String SHARDING_VOLUME_KEY = "sharding-volume";

    @Override
    public Map<Integer, Range<Comparable<?>>> calculatePartitionRange(Properties props) {
        Preconditions.checkState((boolean)props.containsKey(RANGE_LOWER_KEY), (Object)"Lower range cannot be null.");
        Preconditions.checkState((boolean)props.containsKey(RANGE_UPPER_KEY), (Object)"Upper range cannot be null.");
        Preconditions.checkState((boolean)props.containsKey(SHARDING_VOLUME_KEY), (Object)"Sharding volume cannot be null.");
        long lower = Long.parseLong(props.get(RANGE_LOWER_KEY).toString());
        long upper = Long.parseLong(props.get(RANGE_UPPER_KEY).toString());
        long volume = Long.parseLong(props.get(SHARDING_VOLUME_KEY).toString());
        Preconditions.checkArgument((upper - lower >= volume ? 1 : 0) != 0, (Object)"Range can not be smaller than volume.");
        int partitionSize = Math.toIntExact(LongMath.divide((long)(upper - lower), (long)volume, (RoundingMode)RoundingMode.CEILING));
        HashMap result = new HashMap(partitionSize + 2, 1.0f);
        result.put(0, Range.lessThan((Comparable)Long.valueOf(lower)));
        for (int i = 0; i < partitionSize; ++i) {
            result.put(i + 1, Range.closedOpen((Comparable)Long.valueOf(lower + (long)i * volume), (Comparable)Long.valueOf(Math.min(lower + (long)(i + 1) * volume, upper))));
        }
        result.put(partitionSize + 1, Range.atLeast((Comparable)Long.valueOf(upper)));
        return result;
    }

    public String getType() {
        return "VOLUME_RANGE";
    }

    public Collection<String> getAllPropertyKeys() {
        return Arrays.asList(RANGE_LOWER_KEY, RANGE_UPPER_KEY, SHARDING_VOLUME_KEY);
    }
}

