/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.cosid;

import java.util.Collection;
import java.util.Properties;
import lombok.Generated;
import me.ahoo.cosid.sharding.ModCycle;
import org.apache.shardingsphere.sharding.algorithm.sharding.cosid.PropertiesUtil;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;

public final class CosIdModShardingAlgorithm<T extends Number>
implements StandardShardingAlgorithm<T> {
    public static final String TYPE = "COSID_MOD";
    public static final String MODULO_KEY = "mod";
    private Properties props = new Properties();
    private volatile ModCycle<T> modCycle;

    public void init() {
        String divisorStr = PropertiesUtil.getRequiredValue(this.getProps(), MODULO_KEY);
        int divisor = Integer.parseInt(divisorStr);
        String logicNamePrefix = PropertiesUtil.getRequiredValue(this.getProps(), "logic-name-prefix");
        this.modCycle = new ModCycle(divisor, logicNamePrefix);
    }

    public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<T> shardingValue) {
        return this.modCycle.sharding((Number)((Object)shardingValue.getValue()));
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingValue<T> shardingValue) {
        return this.modCycle.sharding(shardingValue.getValueRange());
    }

    public String getType() {
        return TYPE;
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }
}

