/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.classbased;

import java.util.Properties;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.sharding.spi.ShardingAlgorithm;
import org.apache.shardingsphere.spi.typed.TypedSPI;

public final class ClassBasedShardingAlgorithmFactory {
    public static <T extends ShardingAlgorithm> T newInstance(String shardingAlgorithmClassName, Class<T> superShardingAlgorithmClass, Properties props) {
        Class<?> result = Class.forName(shardingAlgorithmClassName);
        if (!superShardingAlgorithmClass.isAssignableFrom(result)) {
            throw new ShardingSphereException("Class %s should be implement %s", new Object[]{shardingAlgorithmClassName, superShardingAlgorithmClass.getName()});
        }
        ShardingAlgorithm instance = (ShardingAlgorithm)result.newInstance();
        ClassBasedShardingAlgorithmFactory.setProperties(instance, props);
        instance.init();
        return (T)instance;
    }

    private static <T extends TypedSPI> void setProperties(T instance, Properties props) {
        if (null == props) {
            return;
        }
        Properties newProps = new Properties();
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> newProps.setProperty(key.toString(), null == value ? null : value.toString())));
        instance.setProps(newProps);
    }

    @Generated
    private ClassBasedShardingAlgorithmFactory() {
    }
}

