/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.api.config.rule;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import lombok.Generated;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;

public final class ShardingTableRuleConfiguration {
    private final String logicTable;
    private final String actualDataNodes;
    private String replaceTablePrefix;
    private ShardingStrategyConfiguration databaseShardingStrategy;
    private ShardingStrategyConfiguration tableShardingStrategy;
    private KeyGenerateStrategyConfiguration keyGenerateStrategy;

    public ShardingTableRuleConfiguration(String logicTable) {
        this(logicTable, null);
    }

    public ShardingTableRuleConfiguration(String logicTable, String actualDataNodes) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)logicTable) ? 1 : 0) != 0, (Object)"LogicTable is required.");
        this.logicTable = logicTable;
        this.actualDataNodes = actualDataNodes;
    }

    @Generated
    public String getLogicTable() {
        return this.logicTable;
    }

    @Generated
    public String getActualDataNodes() {
        return this.actualDataNodes;
    }

    @Generated
    public String getReplaceTablePrefix() {
        return this.replaceTablePrefix;
    }

    @Generated
    public ShardingStrategyConfiguration getDatabaseShardingStrategy() {
        return this.databaseShardingStrategy;
    }

    @Generated
    public ShardingStrategyConfiguration getTableShardingStrategy() {
        return this.tableShardingStrategy;
    }

    @Generated
    public KeyGenerateStrategyConfiguration getKeyGenerateStrategy() {
        return this.keyGenerateStrategy;
    }

    @Generated
    public void setReplaceTablePrefix(String replaceTablePrefix) {
        this.replaceTablePrefix = replaceTablePrefix;
    }

    @Generated
    public void setDatabaseShardingStrategy(ShardingStrategyConfiguration databaseShardingStrategy) {
        this.databaseShardingStrategy = databaseShardingStrategy;
    }

    @Generated
    public void setTableShardingStrategy(ShardingStrategyConfiguration tableShardingStrategy) {
        this.tableShardingStrategy = tableShardingStrategy;
    }

    @Generated
    public void setKeyGenerateStrategy(KeyGenerateStrategyConfiguration keyGenerateStrategy) {
        this.keyGenerateStrategy = keyGenerateStrategy;
    }
}

