/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.route.impl;

import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.hint.HintManager;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingDataSourceRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.SelectStatementHandler;
import org.apache.shardingsphere.transaction.TransactionHolder;

public final class ReadwriteSplittingDataSourceRouter {
    private final ReadwriteSplittingDataSourceRule rule;

    public String route(SQLStatementContext<?> sqlStatementContext) {
        if (this.isPrimaryRoute(sqlStatementContext)) {
            return this.rule.getReadwriteSplittingType().getWriteDataSource();
        }
        if (1 == this.rule.getReadDataSourceNames().size()) {
            return this.rule.getReadDataSourceNames().get(0);
        }
        return this.rule.getLoadBalancer().getDataSource(this.rule.getName(), this.rule.getWriteDataSource(), this.rule.getReadDataSourceNames());
    }

    private boolean isPrimaryRoute(SQLStatementContext<?> sqlStatementContext) {
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        return this.containsLockSegment(sqlStatement) || !(sqlStatement instanceof SelectStatement) || this.isHintWriteRouteOnly(sqlStatementContext) || TransactionHolder.isTransaction();
    }

    private boolean isHintWriteRouteOnly(SQLStatementContext<?> sqlStatementContext) {
        return HintManager.isWriteRouteOnly() || sqlStatementContext instanceof CommonSQLStatementContext && ((CommonSQLStatementContext)sqlStatementContext).isHintWriteRouteOnly();
    }

    private boolean containsLockSegment(SQLStatement sqlStatement) {
        return sqlStatement instanceof SelectStatement && SelectStatementHandler.getLockSegment((SelectStatement)((SelectStatement)sqlStatement)).isPresent();
    }

    @Generated
    public ReadwriteSplittingDataSourceRouter(ReadwriteSplittingDataSourceRule rule) {
        this.rule = rule;
    }
}

