/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.algorithm.loadbalance;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.shardingsphere.readwritesplitting.spi.ReplicaLoadBalanceAlgorithm;

public final class RoundRobinReplicaLoadBalanceAlgorithm
implements ReplicaLoadBalanceAlgorithm {
    private static final ConcurrentHashMap<String, AtomicInteger> COUNTS = new ConcurrentHashMap();

    public String getDataSource(String name, String writeDataSourceName, List<String> readDataSourceNames) {
        AtomicInteger count = COUNTS.containsKey(name) ? COUNTS.get(name) : new AtomicInteger(0);
        COUNTS.putIfAbsent(name, count);
        count.compareAndSet(readDataSourceNames.size(), 0);
        return readDataSourceNames.get(Math.abs(count.getAndIncrement()) % readDataSourceNames.size());
    }

    public String getType() {
        return "ROUND_ROBIN";
    }

    public boolean isDefault() {
        return true;
    }
}

