/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.service.impl;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.mode.metadata.persist.node.SchemaMetaDataNode;
import org.apache.shardingsphere.mode.metadata.persist.service.SchemaBasedPersistService;
import org.apache.shardingsphere.mode.persist.PersistRepository;

public final class SchemaRulePersistService
implements SchemaBasedPersistService<Collection<RuleConfiguration>> {
    private static final String DEFAULT_VERSION = "0";
    private final PersistRepository repository;

    @Override
    public void persist(String schemaName, Collection<RuleConfiguration> configs, boolean isOverwrite) {
        if (!(configs.isEmpty() || !isOverwrite && this.isExisted(schemaName))) {
            this.persist(schemaName, configs);
        }
    }

    @Override
    public void persist(String schemaName, Collection<RuleConfiguration> configs) {
        if (Strings.isNullOrEmpty((String)this.getSchemaActiveVersion(schemaName))) {
            this.repository.persist(SchemaMetaDataNode.getActiveVersionPath(schemaName), DEFAULT_VERSION);
        }
        this.repository.persist(SchemaMetaDataNode.getRulePath(schemaName, this.getSchemaActiveVersion(schemaName)), YamlEngine.marshal(this.createYamlRuleConfigurations(configs)));
    }

    @Override
    public void persist(String schemaName, String version, Collection<RuleConfiguration> configs) {
        this.repository.persist(SchemaMetaDataNode.getRulePath(schemaName, version), YamlEngine.marshal(this.createYamlRuleConfigurations(configs)));
    }

    private Collection<YamlRuleConfiguration> createYamlRuleConfigurations(Collection<RuleConfiguration> ruleConfigs) {
        return new YamlRuleConfigurationSwapperEngine().swapToYamlRuleConfigurations(ruleConfigs);
    }

    @Override
    public Collection<RuleConfiguration> load(String schemaName) {
        return this.isExisted(schemaName) ? new YamlRuleConfigurationSwapperEngine().swapToRuleConfigurations((Collection)YamlEngine.unmarshal((String)this.repository.get(SchemaMetaDataNode.getRulePath(schemaName, this.getSchemaActiveVersion(schemaName))), Collection.class, (boolean)true)) : new LinkedList<RuleConfiguration>();
    }

    @Override
    public Collection<RuleConfiguration> load(String schemaName, String version) {
        String yamlContent = this.repository.get(SchemaMetaDataNode.getRulePath(schemaName, version));
        return Strings.isNullOrEmpty((String)yamlContent) ? new LinkedList<RuleConfiguration>() : new YamlRuleConfigurationSwapperEngine().swapToRuleConfigurations((Collection)YamlEngine.unmarshal((String)this.repository.get(SchemaMetaDataNode.getRulePath(schemaName, this.getSchemaActiveVersion(schemaName))), Collection.class, (boolean)true));
    }

    @Override
    public boolean isExisted(String schemaName) {
        return !Strings.isNullOrEmpty((String)this.getSchemaActiveVersion(schemaName)) && !Strings.isNullOrEmpty((String)this.repository.get(SchemaMetaDataNode.getRulePath(schemaName, this.getSchemaActiveVersion(schemaName))));
    }

    private String getSchemaActiveVersion(String schemaName) {
        return this.repository.get(SchemaMetaDataNode.getActiveVersionPath(schemaName));
    }

    @Generated
    public SchemaRulePersistService(PersistRepository repository) {
        this.repository = repository;
    }
}

