/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.service.impl;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.mode.metadata.persist.node.SchemaMetaDataNode;
import org.apache.shardingsphere.mode.metadata.persist.service.SchemaBasedPersistService;
import org.apache.shardingsphere.mode.persist.PersistRepository;

public final class DataSourcePersistService
implements SchemaBasedPersistService<Map<String, DataSourceProperties>> {
    private static final String DEFAULT_VERSION = "0";
    private final PersistRepository repository;

    @Override
    public void persist(String schemaName, Map<String, DataSourceProperties> dataSourcePropsMap, boolean isOverwrite) {
        if (!(dataSourcePropsMap.isEmpty() || !isOverwrite && this.isExisted(schemaName))) {
            this.persist(schemaName, dataSourcePropsMap);
        }
    }

    @Override
    public void persist(String schemaName, Map<String, DataSourceProperties> dataSourcePropsMap) {
        if (Strings.isNullOrEmpty((String)this.getSchemaActiveVersion(schemaName))) {
            this.repository.persist(SchemaMetaDataNode.getActiveVersionPath(schemaName), DEFAULT_VERSION);
        }
        this.repository.persist(SchemaMetaDataNode.getMetaDataDataSourcePath(schemaName, this.getSchemaActiveVersion(schemaName)), YamlEngine.marshal(this.swapYamlDataSourceConfiguration(dataSourcePropsMap)));
    }

    @Override
    public void persist(String schemaName, String version, Map<String, DataSourceProperties> dataSourcePropsMap) {
        this.repository.persist(SchemaMetaDataNode.getMetaDataDataSourcePath(schemaName, version), YamlEngine.marshal(this.swapYamlDataSourceConfiguration(dataSourcePropsMap)));
    }

    private Map<String, Map<String, Object>> swapYamlDataSourceConfiguration(Map<String, DataSourceProperties> dataSourcePropsMap) {
        return dataSourcePropsMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new YamlDataSourceConfigurationSwapper().swapToMap((DataSourceProperties)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    @Override
    public Map<String, DataSourceProperties> load(String schemaName) {
        return this.isExisted(schemaName) ? this.getDataSourceProperties(this.repository.get(SchemaMetaDataNode.getMetaDataDataSourcePath(schemaName, this.getSchemaActiveVersion(schemaName)))) : new LinkedHashMap<String, DataSourceProperties>();
    }

    @Override
    public Map<String, DataSourceProperties> load(String schemaName, String version) {
        String yamlContent = this.repository.get(SchemaMetaDataNode.getMetaDataDataSourcePath(schemaName, version));
        return Strings.isNullOrEmpty((String)yamlContent) ? new LinkedHashMap() : this.getDataSourceProperties(yamlContent);
    }

    private Map<String, DataSourceProperties> getDataSourceProperties(String yamlContent) {
        Map yamlDataSources = (Map)YamlEngine.unmarshal((String)yamlContent, Map.class);
        if (yamlDataSources.isEmpty()) {
            return new LinkedHashMap<String, DataSourceProperties>();
        }
        LinkedHashMap<String, DataSourceProperties> result = new LinkedHashMap<String, DataSourceProperties>(yamlDataSources.size());
        yamlDataSources.forEach((key, value) -> result.put((String)key, new YamlDataSourceConfigurationSwapper().swapToDataSourceProperties(value)));
        return result;
    }

    @Override
    public boolean isExisted(String schemaName) {
        return !Strings.isNullOrEmpty((String)this.getSchemaActiveVersion(schemaName)) && !Strings.isNullOrEmpty((String)this.repository.get(SchemaMetaDataNode.getMetaDataDataSourcePath(schemaName, this.getSchemaActiveVersion(schemaName))));
    }

    public void append(String schemaName, Map<String, DataSourceProperties> toBeAppendedDataSourcePropsMap) {
        Object dataSourceConfigs = this.load(schemaName);
        dataSourceConfigs.putAll(toBeAppendedDataSourcePropsMap);
        this.persist(schemaName, (Map<String, DataSourceProperties>)dataSourceConfigs);
    }

    public void drop(String schemaName, Collection<String> toBeDroppedDataSourceNames) {
        Object dataSourcePropsMap = this.load(schemaName);
        for (String each : toBeDroppedDataSourceNames) {
            dataSourcePropsMap.remove(each);
        }
        this.persist(schemaName, (Map<String, DataSourceProperties>)dataSourcePropsMap);
    }

    private String getSchemaActiveVersion(String schemaName) {
        return this.repository.get(SchemaMetaDataNode.getActiveVersionPath(schemaName));
    }

    @Generated
    public DataSourcePersistService(PersistRepository repository) {
        this.repository = repository;
    }
}

