/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.node;

import com.google.common.base.Joiner;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class SchemaMetaDataNode {
    private static final String ROOT_NODE = "metadata";
    private static final String DATA_SOURCE_NODE = "dataSources";
    private static final String RULE_NODE = "rules";
    private static final String TABLES_NODE = "tables";
    private static final String ACTIVE_VERSION = "active_version";
    private static final String VERSIONS = "versions";

    public static String getMetaDataDataSourcePath(String schemaName, String version) {
        return Joiner.on((String)"/").join((Object)SchemaMetaDataNode.getFullMetaDataPath(schemaName, VERSIONS), (Object)version, new Object[]{DATA_SOURCE_NODE});
    }

    public static String getMetaDataNodePath() {
        return String.join((CharSequence)"/", "", ROOT_NODE);
    }

    public static String getDatabaseNamePath(String databaseName) {
        return String.join((CharSequence)"/", SchemaMetaDataNode.getMetaDataNodePath(), databaseName);
    }

    public static String getSchemaNamePath(String schemaName) {
        return String.join((CharSequence)"/", "", ROOT_NODE, schemaName);
    }

    public static String getRulePath(String schemaName, String version) {
        return Joiner.on((String)"/").join((Object)SchemaMetaDataNode.getFullMetaDataPath(schemaName, VERSIONS), (Object)version, new Object[]{RULE_NODE});
    }

    public static String getMetaDataTablesPath(String databaseName, String schemaName) {
        return String.join((CharSequence)"/", SchemaMetaDataNode.getDatabaseNamePath(databaseName), schemaName, TABLES_NODE);
    }

    public static String getTableMetaDataPath(String databaseName, String schemaName, String table) {
        return String.join((CharSequence)"/", SchemaMetaDataNode.getMetaDataTablesPath(databaseName, schemaName), table);
    }

    private static String getFullMetaDataPath(String schemaName, String node) {
        return String.join((CharSequence)"/", "", ROOT_NODE, schemaName, schemaName, node);
    }

    public static Optional<String> getSchemaName(String configurationNodeFullPath) {
        Pattern pattern = Pattern.compile(SchemaMetaDataNode.getMetaDataNodePath() + "/([\\w\\-]+)/([\\w\\-]+)(/datasources|/rules|/tables)?", 2);
        Matcher matcher = pattern.matcher(configurationNodeFullPath);
        return matcher.find() ? Optional.of(matcher.group(2)) : Optional.empty();
    }

    public static Optional<String> getDatabaseNameBySchemaPath(String schemaPath) {
        Pattern pattern = Pattern.compile(SchemaMetaDataNode.getMetaDataNodePath() + "/([\\w\\-]+)$", 2);
        Matcher matcher = pattern.matcher(schemaPath);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }

    public static Optional<String> getTableName(String tableMetaDataPath) {
        Pattern pattern = Pattern.compile(SchemaMetaDataNode.getMetaDataNodePath() + "/([\\w\\-]+)/([\\w\\-]+)/tables/([\\w\\-]+)$", 2);
        Matcher matcher = pattern.matcher(tableMetaDataPath);
        return matcher.find() ? Optional.of(matcher.group(3)) : Optional.empty();
    }

    public static String getActiveVersionPath(String schemaName) {
        return SchemaMetaDataNode.getFullMetaDataPath(schemaName, ACTIVE_VERSION);
    }

    public static String getSchemaVersionPath(String schemaName, String version) {
        return Joiner.on((String)"/").join((Object)SchemaMetaDataNode.getFullMetaDataPath(schemaName, VERSIONS), (Object)version, new Object[0]);
    }

    public static Optional<String> getVersionByDataSourcesPath(String dataSourceNodeFullPath) {
        Pattern pattern = Pattern.compile(SchemaMetaDataNode.getMetaDataNodePath() + "/([\\w\\-]+)/([\\w\\-]+)/versions/([\\w\\-]+)/dataSources", 2);
        Matcher matcher = pattern.matcher(dataSourceNodeFullPath);
        return matcher.find() ? Optional.of(matcher.group(3)) : Optional.empty();
    }

    public static Optional<String> getVersionByRulesPath(String rulesNodeFullPath) {
        Pattern pattern = Pattern.compile(SchemaMetaDataNode.getMetaDataNodePath() + "/([\\w\\-]+)/([\\w\\-]+)/versions/([\\w\\-]+)/rules", 2);
        Matcher matcher = pattern.matcher(rulesNodeFullPath);
        return matcher.find() ? Optional.of(matcher.group(3)) : Optional.empty();
    }

    @Generated
    private SchemaMetaDataNode() {
    }
}

