/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.resultset;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import lombok.Generated;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;

public final class ResultSetUtil {
    public static Object convertValue(Object value, Class<?> convertType) throws SQLException {
        if (null == convertType) {
            throw new SQLException("Type cannot be null");
        }
        if (null == value) {
            return ResultSetUtil.convertNullValue(convertType);
        }
        if (value.getClass() == convertType) {
            return value;
        }
        if (value instanceof LocalDateTime) {
            return ResultSetUtil.convertLocalDateTimeValue(value, convertType);
        }
        if (value instanceof Timestamp) {
            return ResultSetUtil.convertTimestampValue(value, convertType);
        }
        if (URL.class.equals(convertType)) {
            return ResultSetUtil.convertURL(value);
        }
        if (value instanceof Number) {
            return ResultSetUtil.convertNumberValue(value, convertType);
        }
        if (value instanceof java.util.Date) {
            return ResultSetUtil.convertDateValue(value, convertType);
        }
        if (value instanceof byte[]) {
            return ResultSetUtil.convertByteArrayValue(value, convertType);
        }
        if (Boolean.TYPE.equals(convertType)) {
            return ResultSetUtil.convertBooleanValue(value);
        }
        if (String.class.equals(convertType)) {
            return value.toString();
        }
        throw new SQLFeatureNotSupportedException("getObject with type");
    }

    private static Object convertURL(Object value) {
        String val = value.toString();
        try {
            return new URL(val);
        }
        catch (MalformedURLException ex) {
            throw new ShardingSphereException("Unsupported data type: URL for value %s", new Object[]{val});
        }
    }

    public static Object convertBigDecimalValue(Object value, boolean needScale, int scale) {
        if (null == value) {
            return ResultSetUtil.convertNullValue(BigDecimal.class);
        }
        if (BigDecimal.class == value.getClass()) {
            return ResultSetUtil.adjustBigDecimalResult((BigDecimal)value, needScale, scale);
        }
        if (value instanceof Number || value instanceof String) {
            BigDecimal bigDecimal = new BigDecimal(value.toString());
            return ResultSetUtil.adjustBigDecimalResult(bigDecimal, needScale, scale);
        }
        throw new ShardingSphereException("Unsupported data type: BigDecimal for value %s", new Object[]{value});
    }

    private static BigDecimal adjustBigDecimalResult(BigDecimal value, boolean needScale, int scale) {
        if (needScale) {
            try {
                return value.setScale(scale);
            }
            catch (ArithmeticException ex) {
                return value.setScale(scale, 4);
            }
        }
        return value;
    }

    private static Object convertLocalDateTimeValue(Object value, Class<?> convertType) {
        LocalDateTime localDateTime = (LocalDateTime)value;
        if (Timestamp.class.equals(convertType)) {
            return Timestamp.valueOf(localDateTime);
        }
        return value;
    }

    private static Object convertTimestampValue(Object value, Class<?> convertType) {
        Timestamp timestamp = (Timestamp)value;
        if (LocalDateTime.class.equals(convertType)) {
            return timestamp.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
        if (LocalDate.class.equals(convertType)) {
            return timestamp.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        }
        if (LocalTime.class.equals(convertType)) {
            return timestamp.toInstant().atZone(ZoneId.systemDefault()).toLocalTime();
        }
        return value;
    }

    private static Object convertNullValue(Class<?> convertType) {
        switch (convertType.getName()) {
            case "boolean": {
                return false;
            }
            case "byte": {
                return (byte)0;
            }
            case "short": {
                return (short)0;
            }
            case "int": {
                return 0;
            }
            case "long": {
                return 0L;
            }
            case "float": {
                return Float.valueOf(0.0f);
            }
            case "double": {
                return 0.0;
            }
        }
        return null;
    }

    private static Object convertNumberValue(Object value, Class<?> convertType) {
        Number number = (Number)value;
        switch (convertType.getName()) {
            case "boolean": {
                return ResultSetUtil.longToBoolean(number.longValue());
            }
            case "byte": {
                return number.byteValue();
            }
            case "short": {
                return number.shortValue();
            }
            case "int": {
                return number.intValue();
            }
            case "long": {
                return number.longValue();
            }
            case "double": {
                return number.doubleValue();
            }
            case "float": {
                return Float.valueOf(number.floatValue());
            }
            case "java.math.BigDecimal": {
                return new BigDecimal(number.toString());
            }
            case "java.lang.Byte": {
                return number.byteValue();
            }
            case "java.lang.Short": {
                return number.shortValue();
            }
            case "java.lang.Integer": {
                return number.intValue();
            }
            case "java.lang.Long": {
                return number.longValue();
            }
            case "java.lang.Double": {
                return number.doubleValue();
            }
            case "java.lang.Float": {
                return Float.valueOf(number.floatValue());
            }
            case "java.lang.Object": {
                return value;
            }
            case "java.lang.String": {
                return value.toString();
            }
        }
        throw new ShardingSphereException("Unsupported data type: %s for value %s", new Object[]{convertType, value});
    }

    private static Object convertDateValue(Object value, Class<?> convertType) {
        java.util.Date date = (java.util.Date)value;
        switch (convertType.getName()) {
            case "java.sql.Date": {
                return new Date(date.getTime());
            }
            case "java.sql.Time": {
                return new Time(date.getTime());
            }
            case "java.sql.Timestamp": {
                return new Timestamp(date.getTime());
            }
            case "java.lang.String": {
                return date.toString();
            }
        }
        throw new ShardingSphereException("Unsupported date type: %s for value %s", new Object[]{convertType, value});
    }

    private static Object convertByteArrayValue(Object value, Class<?> convertType) {
        byte[] bytesValue = (byte[])value;
        switch (bytesValue.length) {
            case 1: {
                return ResultSetUtil.convertNumberValue(bytesValue[0], convertType);
            }
            case 2: {
                return ResultSetUtil.convertNumberValue(Shorts.fromByteArray((byte[])bytesValue), convertType);
            }
            case 4: {
                return ResultSetUtil.convertNumberValue(Ints.fromByteArray((byte[])bytesValue), convertType);
            }
            case 8: {
                return ResultSetUtil.convertNumberValue(Longs.fromByteArray((byte[])bytesValue), convertType);
            }
        }
        return value;
    }

    private static Object convertBooleanValue(Object value) {
        if (value instanceof Boolean) {
            return value;
        }
        String stringVal = value.toString();
        if (stringVal.length() > 0) {
            char firstChar = Character.toLowerCase(stringVal.charAt(0));
            return 't' == firstChar || 'y' == firstChar || '1' == firstChar || "-1".equals(stringVal);
        }
        return false;
    }

    private static Boolean longToBoolean(long longVal) {
        return -1L == longVal || longVal > 0L;
    }

    @Generated
    private ResultSetUtil() {
    }
}

