/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.connection;

import java.sql.Array;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import lombok.Generated;
import org.apache.shardingsphere.driver.jdbc.adapter.AbstractConnectionAdapter;
import org.apache.shardingsphere.driver.jdbc.core.connection.ConnectionManager;
import org.apache.shardingsphere.driver.jdbc.core.datasource.metadata.ShardingSphereDatabaseMetaData;
import org.apache.shardingsphere.driver.jdbc.core.statement.ShardingSpherePreparedStatement;
import org.apache.shardingsphere.driver.jdbc.core.statement.ShardingSphereStatement;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.traffic.context.TrafficContextHolder;
import org.apache.shardingsphere.transaction.TransactionHolder;

public final class ShardingSphereConnection
extends AbstractConnectionAdapter {
    private final String schema;
    private final ContextManager contextManager;
    private final ConnectionManager connectionManager;
    private boolean autoCommit = true;
    private int transactionIsolation = 1;
    private boolean readOnly;
    private volatile boolean closed;

    public ShardingSphereConnection(String schema, ContextManager contextManager) {
        this.schema = schema;
        this.contextManager = contextManager;
        this.connectionManager = new ConnectionManager(schema, contextManager);
    }

    public boolean isHoldTransaction() {
        return this.connectionManager.getConnectionTransaction().isHoldTransaction(this.autoCommit);
    }

    @Override
    public DatabaseMetaData getMetaData() {
        return new ShardingSphereDatabaseMetaData(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new ShardingSpherePreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new ShardingSpherePreparedStatement(this, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new ShardingSpherePreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new ShardingSpherePreparedStatement(this, sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new ShardingSpherePreparedStatement(this, sql, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new ShardingSpherePreparedStatement(this, sql, 1);
    }

    @Override
    public Statement createStatement() {
        return new ShardingSphereStatement(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) {
        return new ShardingSphereStatement(this, resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new ShardingSphereStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.autoCommit = autoCommit;
        if (this.connectionManager.getConnectionTransaction().isLocalTransaction()) {
            this.processLocalTransaction();
        } else {
            this.processDistributeTransaction();
        }
    }

    private void processLocalTransaction() throws SQLException {
        this.connectionManager.setAutoCommit(this.autoCommit);
        if (!this.autoCommit) {
            TransactionHolder.setInTransaction();
        }
    }

    private void processDistributeTransaction() throws SQLException {
        switch (this.connectionManager.getConnectionTransaction().getDistributedTransactionOperationType(this.autoCommit)) {
            case BEGIN: {
                this.connectionManager.close();
                this.connectionManager.getConnectionTransaction().begin();
                TransactionHolder.setInTransaction();
                break;
            }
            case COMMIT: {
                this.connectionManager.getConnectionTransaction().commit();
                break;
            }
        }
    }

    @Override
    public void commit() throws SQLException {
        try {
            this.connectionManager.commit();
        }
        finally {
            this.connectionManager.getConnectionTransaction().setRollbackOnly(false);
            TransactionHolder.clear();
            TrafficContextHolder.remove();
        }
    }

    @Override
    public void rollback() throws SQLException {
        try {
            this.connectionManager.rollback();
        }
        finally {
            this.connectionManager.getConnectionTransaction().setRollbackOnly(false);
            TransactionHolder.clear();
            TrafficContextHolder.remove();
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkClose();
        this.connectionManager.rollback(savepoint);
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkClose();
        return this.connectionManager.setSavepoint(name);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkClose();
        return this.connectionManager.setSavepoint();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClose();
        this.connectionManager.releaseSavepoint(savepoint);
    }

    private void checkClose() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("This connection has been closed");
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.connectionManager.getTransactionIsolation().orElseGet(() -> this.transactionIsolation);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.transactionIsolation = level;
        this.connectionManager.setTransactionIsolation(level);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.readOnly = readOnly;
        this.connectionManager.setReadOnly(readOnly);
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.connectionManager.isValid(timeout);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.connectionManager.getRandomConnection().createArrayOf(typeName, elements);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
        this.connectionManager.close();
    }

    @Override
    @Generated
    public String getSchema() {
        return this.schema;
    }

    @Generated
    public ContextManager getContextManager() {
        return this.contextManager;
    }

    @Generated
    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }
}

