/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.config.datasource;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.data.pipeline.core.datasource.creator.PipelineDataSourceCreator;
import org.apache.shardingsphere.driver.api.ShardingSphereDataSourceFactory;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRootConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.swapper.ShardingRuleConfigurationConverter;

public final class ShardingSpherePipelineDataSourceCreator
implements PipelineDataSourceCreator {
    public DataSource createPipelineDataSource(Object pipelineDataSourceConfig) throws SQLException {
        YamlRootConfiguration rootConfig = (YamlRootConfiguration)pipelineDataSourceConfig;
        ShardingRuleConfiguration shardingRuleConfig = ShardingRuleConfigurationConverter.findAndConvertShardingRuleConfiguration((Collection)rootConfig.getRules());
        this.enableRangeQueryForInline(shardingRuleConfig);
        return ShardingSphereDataSourceFactory.createDataSource(rootConfig.getSchemaName(), (Map<String, DataSource>)new YamlDataSourceConfigurationSwapper().swapToDataSources(rootConfig.getDataSources()), Collections.singletonList(shardingRuleConfig), null);
    }

    private void enableRangeQueryForInline(ShardingRuleConfiguration shardingRuleConfig) {
        for (ShardingSphereAlgorithmConfiguration each : shardingRuleConfig.getShardingAlgorithms().values()) {
            if (!"INLINE".equalsIgnoreCase(each.getType())) continue;
            each.getProps().put("allow-range-query-with-inline-sharding", "true");
        }
    }

    public String getType() {
        return "ShardingSphereJDBC";
    }
}

