/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.api;

import com.google.common.base.Strings;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.driver.jdbc.core.datasource.ShardingSphereDataSource;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;

public final class ShardingSphereDataSourceFactory {
    public static DataSource createDataSource(String schemaName, ModeConfiguration modeConfig) throws SQLException {
        return new ShardingSphereDataSource(Strings.isNullOrEmpty((String)schemaName) ? "logic_db" : schemaName, modeConfig);
    }

    public static DataSource createDataSource(ModeConfiguration modeConfig) throws SQLException {
        return ShardingSphereDataSourceFactory.createDataSource("logic_db", modeConfig);
    }

    public static DataSource createDataSource(String schemaName, ModeConfiguration modeConfig, Map<String, DataSource> dataSourceMap, Collection<RuleConfiguration> configs, Properties props) throws SQLException {
        return new ShardingSphereDataSource(Strings.isNullOrEmpty((String)schemaName) ? "logic_db" : schemaName, modeConfig, dataSourceMap, configs, props);
    }

    public static DataSource createDataSource(ModeConfiguration modeConfig, Map<String, DataSource> dataSourceMap, Collection<RuleConfiguration> configs, Properties props) throws SQLException {
        return ShardingSphereDataSourceFactory.createDataSource("logic_db", modeConfig, dataSourceMap, configs, props);
    }

    public static DataSource createDataSource(String schemaName, ModeConfiguration modeConfig, DataSource dataSource, Collection<RuleConfiguration> configs, Properties props) throws SQLException {
        return ShardingSphereDataSourceFactory.createDataSource(schemaName, modeConfig, Collections.singletonMap(Strings.isNullOrEmpty((String)schemaName) ? "logic_db" : schemaName, dataSource), configs, props);
    }

    public static DataSource createDataSource(ModeConfiguration modeConfig, DataSource dataSource, Collection<RuleConfiguration> configs, Properties props) throws SQLException {
        return ShardingSphereDataSourceFactory.createDataSource(modeConfig, Collections.singletonMap("logic_db", dataSource), configs, props);
    }

    public static DataSource createDataSource(String schemaName, Map<String, DataSource> dataSourceMap, Collection<RuleConfiguration> configs, Properties props) throws SQLException {
        return ShardingSphereDataSourceFactory.createDataSource(schemaName, null, dataSourceMap, configs, props);
    }

    public static DataSource createDataSource(Map<String, DataSource> dataSourceMap, Collection<RuleConfiguration> configs, Properties props) throws SQLException {
        return ShardingSphereDataSourceFactory.createDataSource((ModeConfiguration)null, dataSourceMap, configs, props);
    }

    public static DataSource createDataSource(String schemaName, DataSource dataSource, Collection<RuleConfiguration> configs, Properties props) throws SQLException {
        return ShardingSphereDataSourceFactory.createDataSource(schemaName, null, dataSource, configs, props);
    }

    public static DataSource createDataSource(DataSource dataSource, Collection<RuleConfiguration> configs, Properties props) throws SQLException {
        return ShardingSphereDataSourceFactory.createDataSource((ModeConfiguration)null, dataSource, configs, props);
    }

    @Generated
    private ShardingSphereDataSourceFactory() {
    }
}

