/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.schema.loader.dialect;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.metadata.schema.loader.common.DataTypeLoader;
import org.apache.shardingsphere.infra.metadata.schema.loader.spi.DialectTableMetaDataLoader;
import org.apache.shardingsphere.infra.metadata.schema.model.ColumnMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.ConstraintMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.IndexMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;

public final class MySQLTableMetaDataLoader
implements DialectTableMetaDataLoader {
    private static final String ORDER_BY_ORDINAL_POSITION = " ORDER BY ORDINAL_POSITION";
    private static final String TABLE_META_DATA_NO_ORDER = "SELECT TABLE_NAME, COLUMN_NAME, DATA_TYPE, COLUMN_KEY, EXTRA, COLLATION_NAME, ORDINAL_POSITION FROM information_schema.columns WHERE TABLE_SCHEMA=?";
    private static final String TABLE_META_DATA_SQL = "SELECT TABLE_NAME, COLUMN_NAME, DATA_TYPE, COLUMN_KEY, EXTRA, COLLATION_NAME, ORDINAL_POSITION FROM information_schema.columns WHERE TABLE_SCHEMA=? ORDER BY ORDINAL_POSITION";
    private static final String TABLE_META_DATA_SQL_IN_TABLES = "SELECT TABLE_NAME, COLUMN_NAME, DATA_TYPE, COLUMN_KEY, EXTRA, COLLATION_NAME, ORDINAL_POSITION FROM information_schema.columns WHERE TABLE_SCHEMA=? AND TABLE_NAME IN (%s) ORDER BY ORDINAL_POSITION";
    private static final String INDEX_META_DATA_SQL = "SELECT TABLE_NAME, INDEX_NAME FROM information_schema.statistics WHERE TABLE_SCHEMA=? and TABLE_NAME IN (%s)";
    private static final String CONSTRAINT_META_DATA_SQL = "SELECT CONSTRAINT_NAME, TABLE_NAME, REFERENCED_TABLE_NAME FROM information_schema.KEY_COLUMN_USAGE WHERE TABLE_NAME IN (%s) AND REFERENCED_TABLE_SCHEMA IS NOT NULL";

    @Override
    public Map<String, TableMetaData> load(DataSource dataSource, Collection<String> tables) throws SQLException {
        LinkedHashMap<String, TableMetaData> result = new LinkedHashMap<String, TableMetaData>();
        Map<String, Collection<ColumnMetaData>> columnMetaDataMap = this.loadColumnMetaDataMap(dataSource, tables);
        Map indexMetaDataMap = columnMetaDataMap.isEmpty() ? Collections.emptyMap() : this.loadIndexMetaData(dataSource, columnMetaDataMap.keySet());
        Map constraintMetaDataMap = columnMetaDataMap.isEmpty() ? Collections.emptyMap() : this.loadConstraintMetaDataMap(dataSource, columnMetaDataMap.keySet());
        for (Map.Entry<String, Collection<ColumnMetaData>> entry : columnMetaDataMap.entrySet()) {
            Collection indexMetaDataList = indexMetaDataMap.getOrDefault(entry.getKey(), Collections.emptyList());
            Collection constraintMetaDataList = constraintMetaDataMap.getOrDefault(entry.getKey(), Collections.emptyList());
            result.put(entry.getKey(), new TableMetaData(entry.getKey(), entry.getValue(), indexMetaDataList, constraintMetaDataList));
        }
        return result;
    }

    private Map<String, Collection<ConstraintMetaData>> loadConstraintMetaDataMap(DataSource dataSource, Collection<String> tables) throws SQLException {
        LinkedHashMap<String, Collection<ConstraintMetaData>> result = new LinkedHashMap<String, Collection<ConstraintMetaData>>();
        try (Connection connection = dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.getConstraintMetaDataSQL(tables));
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                String constraintName = resultSet.getString("CONSTRAINT_NAME");
                String tableName = resultSet.getString("TABLE_NAME");
                String referencedTableName = resultSet.getString("REFERENCED_TABLE_NAME");
                if (!result.containsKey(tableName)) {
                    result.put(tableName, new LinkedList());
                }
                ((Collection)result.get(tableName)).add(new ConstraintMetaData(constraintName, referencedTableName));
            }
        }
        return result;
    }

    private String getConstraintMetaDataSQL(Collection<String> tableNames) {
        return String.format(CONSTRAINT_META_DATA_SQL, tableNames.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    private Map<String, Collection<ColumnMetaData>> loadColumnMetaDataMap(DataSource dataSource, Collection<String> tables) throws SQLException {
        HashMap<String, Collection<ColumnMetaData>> result = new HashMap<String, Collection<ColumnMetaData>>();
        try (Connection connection = dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.getTableMetaDataSQL(tables));){
            Map<String, Integer> dataTypes = DataTypeLoader.load(connection.getMetaData());
            this.appendDataTypes(dataTypes);
            preparedStatement.setString(1, connection.getCatalog());
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    ColumnMetaData columnMetaData = this.loadColumnMetaData(dataTypes, resultSet);
                    if (!result.containsKey(tableName)) {
                        result.put(tableName, new LinkedList());
                    }
                    ((Collection)result.get(tableName)).add(columnMetaData);
                }
            }
        }
        return result;
    }

    private void appendDataTypes(Map<String, Integer> dataTypes) {
        dataTypes.putIfAbsent("JSON", -1);
        dataTypes.putIfAbsent("GEOMETRY", -2);
        dataTypes.putIfAbsent("YEAR", 91);
    }

    private ColumnMetaData loadColumnMetaData(Map<String, Integer> dataTypeMap, ResultSet resultSet) throws SQLException {
        String columnName = resultSet.getString("COLUMN_NAME");
        String dataType = resultSet.getString("DATA_TYPE");
        boolean primaryKey = "PRI".equals(resultSet.getString("COLUMN_KEY"));
        boolean generated = "auto_increment".equals(resultSet.getString("EXTRA"));
        String collationName = resultSet.getString("COLLATION_NAME");
        boolean caseSensitive = null != collationName && !collationName.endsWith("_ci");
        return new ColumnMetaData(columnName, dataTypeMap.get(dataType), primaryKey, generated, caseSensitive);
    }

    private String getTableMetaDataSQL(Collection<String> tables) {
        return tables.isEmpty() ? TABLE_META_DATA_SQL : String.format(TABLE_META_DATA_SQL_IN_TABLES, tables.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    private Map<String, Collection<IndexMetaData>> loadIndexMetaData(DataSource dataSource, Collection<String> tableNames) throws SQLException {
        HashMap<String, Collection<IndexMetaData>> result = new HashMap<String, Collection<IndexMetaData>>();
        try (Connection connection = dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.getIndexMetaDataSQL(tableNames));){
            preparedStatement.setString(1, connection.getCatalog());
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String indexName = resultSet.getString("INDEX_NAME");
                    String tableName = resultSet.getString("TABLE_NAME");
                    if (!result.containsKey(tableName)) {
                        result.put(tableName, new LinkedList());
                    }
                    ((Collection)result.get(tableName)).add(new IndexMetaData(indexName));
                }
            }
        }
        return result;
    }

    private String getIndexMetaDataSQL(Collection<String> tableNames) {
        return String.format(INDEX_META_DATA_SQL, tableNames.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    @Override
    public String getDatabaseType() {
        return "MySQL";
    }
}

