/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.resource;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.database.metadata.DataSourceMetaData;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.datasource.props.DataSourcePropertiesCreator;

public final class DataSourcesMetaData {
    private final Map<String, DataSourceMetaData> dataSourceMetaDataMap;

    public DataSourcesMetaData(DatabaseType databaseType, Map<String, DataSource> dataSourceMap) {
        this.dataSourceMetaDataMap = new LinkedHashMap<String, DataSourceMetaData>(dataSourceMap.size(), 1.0f);
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            Map<String, Object> standardProps = DataSourcePropertiesCreator.create(entry.getValue()).getConnectionPropertySynonyms().getStandardProperties();
            this.dataSourceMetaDataMap.put(entry.getKey(), databaseType.getDataSourceMetaData(standardProps.get("url").toString(), standardProps.get("username").toString()));
        }
    }

    public Collection<String> getAllInstanceDataSourceNames() {
        LinkedList<String> result = new LinkedList<String>();
        for (Map.Entry<String, DataSourceMetaData> entry : this.dataSourceMetaDataMap.entrySet()) {
            if (this.isExisted(entry.getKey(), result)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    private boolean isExisted(String dataSourceName, Collection<String> existedDataSourceNames) {
        DataSourceMetaData dataSourceMetaData = this.dataSourceMetaDataMap.get(dataSourceName);
        return existedDataSourceNames.stream().anyMatch(each -> dataSourceMetaData.isInSameDatabaseInstance(this.dataSourceMetaDataMap.get(each)));
    }

    public DataSourceMetaData getDataSourceMetaData(String dataSourceName) {
        return this.dataSourceMetaDataMap.get(dataSourceName);
    }
}

