/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rule;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptColumnRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.rule.EncryptColumn;
import org.apache.shardingsphere.encrypt.spi.context.EncryptColumnDataType;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;

public final class EncryptTable {
    private final Map<String, EncryptColumn> columns = new TreeMap<String, EncryptColumn>(String.CASE_INSENSITIVE_ORDER);
    private final Boolean queryWithCipherColumn;

    public EncryptTable(EncryptTableRuleConfiguration config, Map<String, Integer> dataTypes) {
        for (EncryptColumnRuleConfiguration each : config.getColumns()) {
            this.checkColumnConfig(each);
            this.columns.put(each.getLogicColumn(), new EncryptColumn(this.getEncryptColumnDataType(each.getLogicDataType(), dataTypes), each.getCipherColumn(), this.getEncryptColumnDataType(each.getCipherDataType(), dataTypes), each.getAssistedQueryColumn(), this.getEncryptColumnDataType(each.getAssistedQueryDataType(), dataTypes), each.getPlainColumn(), this.getEncryptColumnDataType(each.getPlainDataType(), dataTypes), each.getEncryptorName()));
        }
        this.queryWithCipherColumn = config.getQueryWithCipherColumn();
    }

    private EncryptColumnDataType getEncryptColumnDataType(String dataTypeName, Map<String, Integer> dataTypes) {
        return Strings.isNullOrEmpty((String)dataTypeName) ? null : new EncryptColumnDataType(dataTypeName, dataTypes);
    }

    private void checkColumnConfig(EncryptColumnRuleConfiguration columnRuleConfiguration) {
        if (!Strings.isNullOrEmpty((String)columnRuleConfiguration.getLogicDataType())) {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)columnRuleConfiguration.getCipherDataType()) ? 1 : 0) != 0);
            Preconditions.checkState((Strings.isNullOrEmpty((String)columnRuleConfiguration.getPlainColumn()) || !Strings.isNullOrEmpty((String)columnRuleConfiguration.getPlainDataType()) ? 1 : 0) != 0);
            Preconditions.checkState((Strings.isNullOrEmpty((String)columnRuleConfiguration.getAssistedQueryColumn()) || !Strings.isNullOrEmpty((String)columnRuleConfiguration.getAssistedQueryDataType()) ? 1 : 0) != 0);
        }
    }

    public Optional<String> findEncryptorName(String logicColumn) {
        return this.columns.containsKey(logicColumn) ? Optional.of(this.columns.get(logicColumn).getEncryptorName()) : Optional.empty();
    }

    public Collection<String> getLogicColumns() {
        return this.columns.keySet();
    }

    public String getLogicColumn(String cipherColumn) {
        for (Map.Entry<String, EncryptColumn> entry : this.columns.entrySet()) {
            if (!entry.getValue().getCipherColumn().equals(cipherColumn)) continue;
            return entry.getKey();
        }
        throw new ShardingSphereException("Can not find logic column by %s.", new Object[]{cipherColumn});
    }

    public boolean isCipherColumn(String columnName) {
        return this.columns.values().stream().anyMatch(each -> each.getCipherColumn().equalsIgnoreCase(columnName));
    }

    public String getCipherColumn(String logicColumn) {
        return this.columns.get(logicColumn).getCipherColumn();
    }

    public Collection<String> getAssistedQueryColumns() {
        LinkedList<String> result = new LinkedList<String>();
        for (EncryptColumn each : this.columns.values()) {
            if (!each.getAssistedQueryColumn().isPresent()) continue;
            result.add(each.getAssistedQueryColumn().get());
        }
        return result;
    }

    public Optional<String> findAssistedQueryColumn(String logicColumn) {
        return this.columns.containsKey(logicColumn) ? this.columns.get(logicColumn).getAssistedQueryColumn() : Optional.empty();
    }

    public Collection<String> getPlainColumns() {
        LinkedList<String> result = new LinkedList<String>();
        for (EncryptColumn each : this.columns.values()) {
            if (!each.getPlainColumn().isPresent()) continue;
            result.add(each.getPlainColumn().get());
        }
        return result;
    }

    public Optional<String> findPlainColumn(String logicColumn) {
        return this.columns.containsKey(logicColumn) ? this.columns.get(logicColumn).getPlainColumn() : Optional.empty();
    }

    public Map<String, String> getLogicAndCipherColumns() {
        return Maps.transformValues(this.columns, EncryptColumn::getCipherColumn);
    }

    public Optional<Boolean> getQueryWithCipherColumn() {
        return Optional.ofNullable(this.queryWithCipherColumn);
    }

    public Optional<EncryptColumn> findEncryptColumn(String logicColumn) {
        return Optional.ofNullable(this.columns.get(logicColumn));
    }
}

