/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rule;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.algorithm.config.AlgorithmProvidedEncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptColumnRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.context.EncryptContextBuilder;
import org.apache.shardingsphere.encrypt.rule.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.EncryptTable;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.encrypt.spi.QueryAssistedEncryptAlgorithm;
import org.apache.shardingsphere.encrypt.spi.context.EncryptContext;
import org.apache.shardingsphere.infra.config.TypedSPIConfiguration;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmFactory;
import org.apache.shardingsphere.infra.config.exception.ShardingSphereConfigurationException;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.schema.loader.common.DataTypeLoader;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.SchemaMetaDataAware;
import org.apache.shardingsphere.infra.rule.identifier.scope.SchemaRule;
import org.apache.shardingsphere.infra.rule.identifier.type.TableContainedRule;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;

public final class EncryptRule
implements SchemaRule,
TableContainedRule {
    private final Map<String, EncryptAlgorithm> encryptors = new LinkedHashMap<String, EncryptAlgorithm>();
    private final Map<String, EncryptTable> tables = new LinkedHashMap<String, EncryptTable>();
    private final boolean queryWithCipherColumn;

    public EncryptRule(EncryptRuleConfiguration config, Map<String, DataSource> dataSourceMap) {
        Preconditions.checkArgument((boolean)this.isValidRuleConfiguration(config), (Object)"Invalid encrypt column configurations in EncryptTableRuleConfigurations.");
        config.getEncryptors().forEach((key, value) -> this.encryptors.put((String)key, (EncryptAlgorithm)ShardingSphereAlgorithmFactory.createAlgorithm((TypedSPIConfiguration)value, EncryptAlgorithm.class)));
        Map dataTypes = this.containsConfigDataTypeColumn(config.getTables()) ? this.getDataTypes(dataSourceMap) : Collections.emptyMap();
        config.getTables().forEach(each -> this.tables.put(each.getName(), new EncryptTable((EncryptTableRuleConfiguration)each, dataTypes)));
        this.queryWithCipherColumn = config.isQueryWithCipherColumn();
    }

    public EncryptRule(AlgorithmProvidedEncryptRuleConfiguration config, Map<String, DataSource> dataSourceMap) {
        Preconditions.checkArgument((boolean)this.isValidRuleConfigurationWithAlgorithmProvided(config), (Object)"Invalid encrypt column configurations in EncryptTableRuleConfigurations.");
        this.encryptors.putAll(config.getEncryptors());
        Map dataTypes = this.containsConfigDataTypeColumn(config.getTables()) ? this.getDataTypes(dataSourceMap) : Collections.emptyMap();
        config.getTables().forEach(each -> this.tables.put(each.getName(), new EncryptTable((EncryptTableRuleConfiguration)each, dataTypes)));
        this.queryWithCipherColumn = config.isQueryWithCipherColumn();
    }

    private boolean isValidRuleConfiguration(EncryptRuleConfiguration config) {
        return config.getEncryptors().isEmpty() && config.getTables().isEmpty() || this.isValidTableConfiguration(config);
    }

    private boolean isValidTableConfiguration(EncryptRuleConfiguration config) {
        for (EncryptTableRuleConfiguration table : config.getTables()) {
            for (EncryptColumnRuleConfiguration column : table.getColumns()) {
                if (this.isValidColumnConfiguration(config, column)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isValidColumnConfiguration(EncryptRuleConfiguration encryptRuleConfig, EncryptColumnRuleConfiguration column) {
        return !Strings.isNullOrEmpty((String)column.getEncryptorName()) && !Strings.isNullOrEmpty((String)column.getCipherColumn()) && this.containsEncryptors(encryptRuleConfig, column);
    }

    private boolean containsEncryptors(EncryptRuleConfiguration encryptRuleConfig, EncryptColumnRuleConfiguration column) {
        return encryptRuleConfig.getEncryptors().keySet().stream().anyMatch(each -> each.equals(column.getEncryptorName()));
    }

    private boolean isValidRuleConfigurationWithAlgorithmProvided(AlgorithmProvidedEncryptRuleConfiguration config) {
        return config.getEncryptors().isEmpty() && config.getTables().isEmpty() || this.isValidTableConfigurationWithAlgorithmProvided(config);
    }

    private boolean isValidTableConfigurationWithAlgorithmProvided(AlgorithmProvidedEncryptRuleConfiguration config) {
        for (EncryptTableRuleConfiguration table : config.getTables()) {
            for (EncryptColumnRuleConfiguration column : table.getColumns()) {
                if (this.isValidColumnConfigurationWithAlgorithmProvided(config, column)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isValidColumnConfigurationWithAlgorithmProvided(AlgorithmProvidedEncryptRuleConfiguration encryptRuleConfig, EncryptColumnRuleConfiguration column) {
        return !Strings.isNullOrEmpty((String)column.getEncryptorName()) && !Strings.isNullOrEmpty((String)column.getCipherColumn()) && encryptRuleConfig.getEncryptors().containsKey(column.getEncryptorName());
    }

    private Map<String, Integer> getDataTypes(Map<String, DataSource> dataSourceMap) {
        Optional<DataSource> dataSource = dataSourceMap.values().stream().findAny();
        if (dataSource.isPresent()) {
            try {
                return DataTypeLoader.load((DatabaseMetaData)dataSource.get().getConnection().getMetaData());
            }
            catch (SQLException ex) {
                throw new ShardingSphereConfigurationException("Can not load data types: %s", new Object[]{ex.getMessage()});
            }
        }
        return Collections.emptyMap();
    }

    private boolean containsConfigDataTypeColumn(Collection<EncryptTableRuleConfiguration> tableRuleConfigurations) {
        for (EncryptTableRuleConfiguration each : tableRuleConfigurations) {
            for (EncryptColumnRuleConfiguration column : each.getColumns()) {
                if (null == column.getLogicDataType() || column.getLogicDataType().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public Optional<EncryptTable> findEncryptTable(String logicTable) {
        return Optional.ofNullable(this.tables.get(logicTable));
    }

    public Optional<EncryptColumn> findEncryptColumn(String logicTable, String columnName) {
        return this.findEncryptTable(logicTable).flatMap(encryptTable -> encryptTable.findEncryptColumn(columnName));
    }

    public Optional<EncryptAlgorithm> findEncryptor(String logicTable, String logicColumn) {
        return this.tables.containsKey(logicTable) ? this.tables.get(logicTable).findEncryptorName(logicColumn).map(this.encryptors::get) : Optional.empty();
    }

    public List<Object> getEncryptValues(String schemaName, String logicTable, String logicColumn, List<Object> originalValues) {
        Optional<EncryptAlgorithm> encryptor = this.findEncryptor(logicTable, logicColumn);
        EncryptContext encryptContext = EncryptContextBuilder.build(schemaName, logicTable, logicColumn, this);
        Preconditions.checkArgument((boolean)encryptor.isPresent(), (String)"Can not find EncryptAlgorithm by %s.%s.", (Object)logicTable, (Object)logicColumn);
        return this.getEncryptValues(encryptor.get(), originalValues, encryptContext);
    }

    private List<Object> getEncryptValues(EncryptAlgorithm encryptor, List<Object> originalValues, EncryptContext encryptContext) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (Object each : originalValues) {
            Object encryptValue = null == each ? null : encryptor.encrypt(each, encryptContext);
            result.add(encryptValue);
        }
        return result;
    }

    public String getCipherColumn(String logicTable, String logicColumn) {
        return this.tables.get(logicTable).getCipherColumn(logicColumn);
    }

    public Map<String, String> getLogicAndCipherColumns(String logicTable) {
        return this.tables.containsKey(logicTable) ? this.tables.get(logicTable).getLogicAndCipherColumns() : Collections.emptyMap();
    }

    public Optional<String> findAssistedQueryColumn(String logicTable, String logicColumn) {
        return this.tables.containsKey(logicTable) ? this.tables.get(logicTable).findAssistedQueryColumn(logicColumn) : Optional.empty();
    }

    public Collection<String> getAssistedQueryColumns(String logicTable) {
        return this.tables.containsKey(logicTable) ? this.tables.get(logicTable).getAssistedQueryColumns() : Collections.emptyList();
    }

    public List<Object> getEncryptAssistedQueryValues(String schemaName, String logicTable, String logicColumn, List<Object> originalValues) {
        Optional<EncryptAlgorithm> encryptor = this.findEncryptor(logicTable, logicColumn);
        EncryptContext encryptContext = EncryptContextBuilder.build(schemaName, logicTable, logicColumn, this);
        Preconditions.checkArgument((encryptor.isPresent() && encryptor.get() instanceof QueryAssistedEncryptAlgorithm ? 1 : 0) != 0, (String)"Can not find QueryAssistedEncryptAlgorithm by %s.%s.", (Object)logicTable, (Object)logicColumn);
        return this.getEncryptAssistedQueryValues((QueryAssistedEncryptAlgorithm)encryptor.get(), originalValues, encryptContext);
    }

    private List<Object> getEncryptAssistedQueryValues(QueryAssistedEncryptAlgorithm encryptor, List<Object> originalValues, EncryptContext encryptContext) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (Object each : originalValues) {
            result.add(null == each ? null : encryptor.queryAssistedEncrypt(each, encryptContext));
        }
        return result;
    }

    public Optional<String> findPlainColumn(String logicTable, String logicColumn) {
        Optional<String> originColumnName = this.findOriginColumnName(logicTable, logicColumn);
        return originColumnName.isPresent() && this.tables.containsKey(logicTable) ? this.tables.get(logicTable).findPlainColumn(originColumnName.get()) : Optional.empty();
    }

    public boolean isQueryWithCipherColumn(String tableName) {
        return this.findEncryptTable(tableName).flatMap(EncryptTable::getQueryWithCipherColumn).orElse(this.queryWithCipherColumn);
    }

    private Optional<String> findOriginColumnName(String logicTable, String logicColumn) {
        for (String each : this.tables.get(logicTable).getLogicColumns()) {
            if (!logicColumn.equalsIgnoreCase(each)) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    public Collection<String> getTables() {
        return this.tables.keySet();
    }

    public String getType() {
        return EncryptRule.class.getSimpleName();
    }

    public void setUpEncryptorSchema(ShardingSphereSchema schema) {
        for (EncryptAlgorithm each : this.encryptors.values()) {
            if (!(each instanceof SchemaMetaDataAware)) continue;
            ((SchemaMetaDataAware)each).setSchema(schema);
        }
    }

    public boolean containsConfigDataType(String tableName, String columnName) {
        return this.findEncryptTable(tableName).flatMap(encryptTable -> encryptTable.findEncryptColumn(columnName).filter(encryptColumn -> null != encryptColumn.getLogicDataType())).isPresent();
    }

    @Generated
    public boolean isQueryWithCipherColumn() {
        return this.queryWithCipherColumn;
    }

    static {
        ShardingSphereServiceLoader.register(EncryptAlgorithm.class);
    }
}

