/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rule;

import com.google.common.base.Strings;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.spi.context.EncryptColumnDataType;

public final class EncryptColumn {
    private final EncryptColumnDataType logicDataType;
    private final String cipherColumn;
    private final EncryptColumnDataType cipherDataType;
    private final String assistedQueryColumn;
    private final EncryptColumnDataType assistedQueryDataType;
    private final String plainColumn;
    private final EncryptColumnDataType plainDataType;
    private final String encryptorName;

    public Optional<String> getAssistedQueryColumn() {
        return Strings.isNullOrEmpty((String)this.assistedQueryColumn) ? Optional.empty() : Optional.of(this.assistedQueryColumn);
    }

    public Optional<String> getPlainColumn() {
        return Strings.isNullOrEmpty((String)this.plainColumn) ? Optional.empty() : Optional.of(this.plainColumn);
    }

    @Generated
    public EncryptColumn(EncryptColumnDataType logicDataType, String cipherColumn, EncryptColumnDataType cipherDataType, String assistedQueryColumn, EncryptColumnDataType assistedQueryDataType, String plainColumn, EncryptColumnDataType plainDataType, String encryptorName) {
        this.logicDataType = logicDataType;
        this.cipherColumn = cipherColumn;
        this.cipherDataType = cipherDataType;
        this.assistedQueryColumn = assistedQueryColumn;
        this.assistedQueryDataType = assistedQueryDataType;
        this.plainColumn = plainColumn;
        this.plainDataType = plainDataType;
        this.encryptorName = encryptorName;
    }

    @Generated
    public EncryptColumnDataType getLogicDataType() {
        return this.logicDataType;
    }

    @Generated
    public String getCipherColumn() {
        return this.cipherColumn;
    }

    @Generated
    public EncryptColumnDataType getCipherDataType() {
        return this.cipherDataType;
    }

    @Generated
    public EncryptColumnDataType getAssistedQueryDataType() {
        return this.assistedQueryDataType;
    }

    @Generated
    public EncryptColumnDataType getPlainDataType() {
        return this.plainDataType;
    }

    @Generated
    public String getEncryptorName() {
        return this.encryptorName;
    }
}

