/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.EncryptConditionsAware;
import org.apache.shardingsphere.encrypt.rewrite.aware.SchemaNameAware;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptCondition;
import org.apache.shardingsphere.encrypt.rewrite.condition.impl.EncryptInCondition;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptPredicateEqualRightValueToken;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptPredicateInRightValueToken;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.aware.EncryptRuleAware;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.WhereAvailable;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.ParametersAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;

public final class EncryptPredicateRightValueTokenGenerator
implements CollectionSQLTokenGenerator,
ParametersAware,
EncryptConditionsAware,
EncryptRuleAware,
SchemaNameAware {
    private List<Object> parameters;
    private Collection<EncryptCondition> encryptConditions;
    private EncryptRule encryptRule;
    private String schemaName;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof WhereAvailable && !((WhereAvailable)sqlStatementContext).getWhereSegments().isEmpty();
    }

    public Collection<SQLToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        LinkedHashSet<SQLToken> result = new LinkedHashSet<SQLToken>();
        for (EncryptCondition each : this.encryptConditions) {
            result.add(this.generateSQLToken(this.schemaName, each));
        }
        return result;
    }

    private SQLToken generateSQLToken(String schemaName, EncryptCondition encryptCondition) {
        List<Object> originalValues = encryptCondition.getValues(this.parameters);
        int startIndex = encryptCondition.getStartIndex();
        boolean queryWithCipherColumn = this.encryptRule.isQueryWithCipherColumn(encryptCondition.getTableName());
        return queryWithCipherColumn ? this.generateSQLTokenForQueryWithCipherColumn(schemaName, encryptCondition, originalValues, startIndex) : this.generateSQLTokenForQueryWithoutCipherColumn(encryptCondition, originalValues, startIndex);
    }

    private SQLToken generateSQLTokenForQueryWithCipherColumn(String schemaName, EncryptCondition encryptCondition, List<Object> originalValues, int startIndex) {
        int stopIndex = encryptCondition.getStopIndex();
        Map<Integer, Object> indexValues = this.getPositionValues(encryptCondition.getPositionValueMap().keySet(), this.getEncryptedValues(schemaName, encryptCondition, originalValues));
        Set<Integer> parameterMarkerIndexes = encryptCondition.getPositionIndexMap().keySet();
        return encryptCondition instanceof EncryptInCondition ? new EncryptPredicateInRightValueToken(startIndex, stopIndex, indexValues, parameterMarkerIndexes) : new EncryptPredicateEqualRightValueToken(startIndex, stopIndex, indexValues, parameterMarkerIndexes);
    }

    private List<Object> getEncryptedValues(String schemaName, EncryptCondition encryptCondition, List<Object> originalValues) {
        Optional<String> assistedQueryColumn = this.encryptRule.findAssistedQueryColumn(encryptCondition.getTableName(), encryptCondition.getColumnName());
        return assistedQueryColumn.isPresent() ? this.encryptRule.getEncryptAssistedQueryValues(schemaName, encryptCondition.getTableName(), encryptCondition.getColumnName(), originalValues) : this.encryptRule.getEncryptValues(schemaName, encryptCondition.getTableName(), encryptCondition.getColumnName(), originalValues);
    }

    private SQLToken generateSQLTokenForQueryWithoutCipherColumn(EncryptCondition encryptCondition, List<Object> originalValues, int startIndex) {
        int stopIndex = encryptCondition.getStopIndex();
        HashMap<Integer, Object> indexValues = new HashMap<Integer, Object>();
        Optional<String> plainColumn = this.encryptRule.findPlainColumn(encryptCondition.getTableName(), encryptCondition.getColumnName());
        if (plainColumn.isPresent()) {
            indexValues.putAll(this.getPositionValues(encryptCondition.getPositionValueMap().keySet(), originalValues));
        } else {
            indexValues.putAll(this.getPositionValues(encryptCondition.getPositionValueMap().keySet(), this.getEncryptedValues(this.schemaName, encryptCondition, originalValues)));
        }
        Set<Integer> parameterMarkerIndexes = encryptCondition.getPositionIndexMap().keySet();
        return encryptCondition instanceof EncryptInCondition ? new EncryptPredicateInRightValueToken(startIndex, stopIndex, indexValues, parameterMarkerIndexes) : new EncryptPredicateEqualRightValueToken(startIndex, stopIndex, indexValues, parameterMarkerIndexes);
    }

    private Map<Integer, Object> getPositionValues(Collection<Integer> valuePositions, List<Object> encryptValues) {
        LinkedHashMap<Integer, Object> result = new LinkedHashMap<Integer, Object>();
        for (int each : valuePositions) {
            result.put(each, encryptValues.get(each));
        }
        return result;
    }

    @Generated
    public void setParameters(List<Object> parameters) {
        this.parameters = parameters;
    }

    @Override
    @Generated
    public void setEncryptConditions(Collection<EncryptCondition> encryptConditions) {
        this.encryptConditions = encryptConditions;
    }

    @Override
    @Generated
    public void setEncryptRule(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }

    @Override
    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }
}

