/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.EncryptTable;
import org.apache.shardingsphere.encrypt.rule.aware.EncryptRuleAware;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.WhereAvailable;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.SchemaMetaDataAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.SubstitutableColumnNameToken;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;

public final class EncryptPredicateColumnTokenGenerator
implements CollectionSQLTokenGenerator,
SchemaMetaDataAware,
EncryptRuleAware {
    private ShardingSphereSchema schema;
    private EncryptRule encryptRule;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof WhereAvailable && !((WhereAvailable)sqlStatementContext).getWhereSegments().isEmpty();
    }

    public Collection<SubstitutableColumnNameToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        List<ColumnSegment> columnSegments = sqlStatementContext instanceof WhereAvailable ? ((WhereAvailable)sqlStatementContext).getColumnSegments() : Collections.emptyList();
        Map columnExpressionTableNames = sqlStatementContext.getTablesContext().findTableNamesByColumnSegment(columnSegments, this.schema);
        return this.generateSQLTokens(columnSegments, columnExpressionTableNames);
    }

    private Collection<SubstitutableColumnNameToken> generateSQLTokens(Collection<ColumnSegment> columnSegments, Map<String, String> columnExpressionTableNames) {
        LinkedHashSet<SubstitutableColumnNameToken> result = new LinkedHashSet<SubstitutableColumnNameToken>();
        for (ColumnSegment each : columnSegments) {
            Optional<String> plainColumn;
            String tableName = Optional.ofNullable(columnExpressionTableNames.get(each.getExpression())).orElse("");
            Optional<EncryptTable> encryptTable = this.encryptRule.findEncryptTable(tableName);
            if (!encryptTable.isPresent() || !encryptTable.get().findEncryptColumn(each.getIdentifier().getValue()).isPresent()) continue;
            int startIndex = each.getOwner().isPresent() ? ((OwnerSegment)each.getOwner().get()).getStopIndex() + 2 : each.getStartIndex();
            int stopIndex = each.getStopIndex();
            boolean queryWithCipherColumn = this.encryptRule.isQueryWithCipherColumn(tableName);
            if (!queryWithCipherColumn && (plainColumn = encryptTable.get().findPlainColumn(each.getIdentifier().getValue())).isPresent()) {
                result.add(new SubstitutableColumnNameToken(startIndex, stopIndex, this.createColumnProjections(plainColumn.get())));
                continue;
            }
            Optional<String> assistedQueryColumn = encryptTable.get().findAssistedQueryColumn(each.getIdentifier().getValue());
            SubstitutableColumnNameToken encryptColumnNameToken = assistedQueryColumn.map(columnName -> new SubstitutableColumnNameToken(startIndex, stopIndex, this.createColumnProjections((String)columnName))).orElseGet(() -> new SubstitutableColumnNameToken(startIndex, stopIndex, this.createColumnProjections(((EncryptTable)encryptTable.get()).getCipherColumn(each.getIdentifier().getValue()))));
            result.add(encryptColumnNameToken);
        }
        return result;
    }

    private Collection<ColumnProjection> createColumnProjections(String columnName) {
        return Collections.singletonList(new ColumnProjection(null, columnName, null));
    }

    @Generated
    public void setSchema(ShardingSphereSchema schema) {
        this.schema = schema;
    }

    @Override
    @Generated
    public void setEncryptRule(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }
}

