/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.SchemaNameAware;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptAssignmentToken;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptFunctionAssignmentToken;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptLiteralAssignmentToken;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptParameterAssignmentToken;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.aware.EncryptRuleAware;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.OnDuplicateKeyColumnsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.InsertStatementHandler;

public final class EncryptInsertOnUpdateTokenGenerator
implements CollectionSQLTokenGenerator<InsertStatementContext>,
EncryptRuleAware,
SchemaNameAware {
    private EncryptRule encryptRule;
    private String schemaName;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof InsertStatementContext && InsertStatementHandler.getOnDuplicateKeyColumnsSegment((InsertStatement)((InsertStatement)((InsertStatementContext)sqlStatementContext).getSqlStatement())).isPresent();
    }

    public Collection<EncryptAssignmentToken> generateSQLTokens(InsertStatementContext insertStatementContext) {
        LinkedList<EncryptAssignmentToken> result = new LinkedList<EncryptAssignmentToken>();
        InsertStatement insertStatement = (InsertStatement)insertStatementContext.getSqlStatement();
        String tableName = insertStatement.getTable().getTableName().getIdentifier().getValue();
        Preconditions.checkState((boolean)InsertStatementHandler.getOnDuplicateKeyColumnsSegment((InsertStatement)insertStatement).isPresent());
        OnDuplicateKeyColumnsSegment onDuplicateKeyColumnsSegment = (OnDuplicateKeyColumnsSegment)InsertStatementHandler.getOnDuplicateKeyColumnsSegment((InsertStatement)insertStatement).get();
        Collection onDuplicateKeyColumnsSegments = onDuplicateKeyColumnsSegment.getColumns();
        if (onDuplicateKeyColumnsSegments.isEmpty()) {
            return result;
        }
        for (AssignmentSegment each : onDuplicateKeyColumnsSegments) {
            boolean leftEncryptorPresent = this.encryptRule.findEncryptor(tableName, ((ColumnSegment)each.getColumns().get(0)).getIdentifier().getValue()).isPresent();
            if (each.getValue() instanceof FunctionSegment && "VALUES".equalsIgnoreCase(((FunctionSegment)each.getValue()).getFunctionName())) {
                ColumnSegment rightColumn = (ColumnSegment)((FunctionSegment)each.getValue()).getParameters().stream().findFirst().get();
                boolean rightEncryptorPresent = this.encryptRule.findEncryptor(tableName, rightColumn.getIdentifier().getValue()).isPresent();
                if (!leftEncryptorPresent && !rightEncryptorPresent) continue;
            }
            if (!leftEncryptorPresent) continue;
            this.generateSQLToken(tableName, each).ifPresent(result::add);
        }
        return result;
    }

    private Optional<EncryptAssignmentToken> generateSQLToken(String tableName, AssignmentSegment assignmentSegment) {
        if (assignmentSegment.getValue() instanceof ParameterMarkerExpressionSegment) {
            return Optional.of(this.generateParameterSQLToken(tableName, assignmentSegment));
        }
        if (assignmentSegment.getValue() instanceof FunctionSegment && "VALUES".equalsIgnoreCase(((FunctionSegment)assignmentSegment.getValue()).getFunctionName())) {
            return Optional.of(this.generateValuesSQLToken(tableName, assignmentSegment, (FunctionSegment)assignmentSegment.getValue()));
        }
        if (assignmentSegment.getValue() instanceof LiteralExpressionSegment) {
            return Optional.of(this.generateLiteralSQLToken(tableName, assignmentSegment));
        }
        return Optional.empty();
    }

    private EncryptAssignmentToken generateParameterSQLToken(String tableName, AssignmentSegment assignmentSegment) {
        EncryptParameterAssignmentToken result = new EncryptParameterAssignmentToken(((ColumnSegment)assignmentSegment.getColumns().get(0)).getStartIndex(), assignmentSegment.getStopIndex());
        String columnName = ((ColumnSegment)assignmentSegment.getColumns().get(0)).getIdentifier().getValue();
        this.addCipherColumn(tableName, columnName, result);
        this.addAssistedQueryColumn(tableName, columnName, result);
        this.addPlainColumn(tableName, columnName, result);
        return result;
    }

    private EncryptAssignmentToken generateLiteralSQLToken(String tableName, AssignmentSegment assignmentSegment) {
        EncryptLiteralAssignmentToken result = new EncryptLiteralAssignmentToken(((ColumnSegment)assignmentSegment.getColumns().get(0)).getStartIndex(), assignmentSegment.getStopIndex());
        this.addCipherAssignment(this.schemaName, tableName, assignmentSegment, result);
        this.addAssistedQueryAssignment(this.schemaName, tableName, assignmentSegment, result);
        this.addPlainAssignment(tableName, assignmentSegment, result);
        return result;
    }

    private EncryptAssignmentToken generateValuesSQLToken(String tableName, AssignmentSegment assignmentSegment, FunctionSegment functionSegment) {
        ColumnSegment columnSegment = (ColumnSegment)assignmentSegment.getColumns().get(0);
        String column = columnSegment.getIdentifier().getValue();
        ColumnSegment valueColumnSegment = (ColumnSegment)functionSegment.getParameters().stream().findFirst().get();
        String valueColumn = valueColumnSegment.getIdentifier().getValue();
        EncryptFunctionAssignmentToken result = new EncryptFunctionAssignmentToken(columnSegment.getStartIndex(), assignmentSegment.getStopIndex());
        boolean cipherColumnPresent = this.encryptRule.findEncryptor(tableName, column).isPresent();
        boolean cipherValueColumnPresent = this.encryptRule.findEncryptor(tableName, valueColumn).isPresent();
        if (cipherColumnPresent && cipherValueColumnPresent) {
            String cipherColumn = this.encryptRule.getCipherColumn(tableName, column);
            String cipherValueColumn = this.encryptRule.getCipherColumn(tableName, valueColumn);
            result.addAssignment(cipherColumn, "VALUES(" + cipherValueColumn + ")");
        } else if (cipherColumnPresent != cipherValueColumnPresent) {
            throw new ShardingSphereException("The SQL clause `%s` is unsupported in encrypt rule.", new Object[]{String.format("%s=VALUES(%s)", column, valueColumn)});
        }
        Optional<String> assistedQueryColumn = this.encryptRule.findAssistedQueryColumn(tableName, column);
        Optional<String> valueAssistedQueryColumn = this.encryptRule.findAssistedQueryColumn(tableName, valueColumn);
        if (assistedQueryColumn.isPresent() && valueAssistedQueryColumn.isPresent()) {
            result.addAssignment(assistedQueryColumn.get(), "VALUES(" + valueAssistedQueryColumn.get() + ")");
        } else if (assistedQueryColumn.isPresent() != valueAssistedQueryColumn.isPresent()) {
            throw new ShardingSphereException("The SQL clause `%s` is unsupported in encrypt rule.", new Object[]{String.format("%s=VALUES(%s)", column, valueColumn)});
        }
        Optional<String> plainColumn = this.encryptRule.findPlainColumn(tableName, column);
        Optional<String> valuePlainColumn = this.encryptRule.findPlainColumn(tableName, valueColumn);
        if (plainColumn.isPresent() && valuePlainColumn.isPresent()) {
            result.addAssignment(plainColumn.get(), "VALUES(" + valuePlainColumn.get() + ")");
        } else if (plainColumn.isPresent() != valuePlainColumn.isPresent()) {
            throw new ShardingSphereException("The SQL clause `%s` is unsupported in encrypt rule.", new Object[]{String.format("%s=VALUES(%s)", column, valueColumn)});
        }
        if (result.getAssignment().isEmpty()) {
            throw new ShardingSphereException("The SQL clause `%s` is unsupported in encrypt rule.", new Object[]{String.format("%s=VALUES(%s)", column, valueColumn)});
        }
        return result;
    }

    private void addCipherColumn(String tableName, String columnName, EncryptParameterAssignmentToken token) {
        token.addColumnName(this.encryptRule.getCipherColumn(tableName, columnName));
    }

    private void addAssistedQueryColumn(String tableName, String columnName, EncryptParameterAssignmentToken token) {
        this.encryptRule.findAssistedQueryColumn(tableName, columnName).ifPresent(token::addColumnName);
    }

    private void addPlainColumn(String tableName, String columnName, EncryptParameterAssignmentToken token) {
        this.encryptRule.findPlainColumn(tableName, columnName).ifPresent(token::addColumnName);
    }

    private void addCipherAssignment(String schemaName, String tableName, AssignmentSegment assignmentSegment, EncryptLiteralAssignmentToken token) {
        Object originalValue = ((LiteralExpressionSegment)assignmentSegment.getValue()).getLiterals();
        Object cipherValue = this.encryptRule.getEncryptValues(schemaName, tableName, ((ColumnSegment)assignmentSegment.getColumns().get(0)).getIdentifier().getValue(), Collections.singletonList(originalValue)).iterator().next();
        token.addAssignment(this.encryptRule.getCipherColumn(tableName, ((ColumnSegment)assignmentSegment.getColumns().get(0)).getIdentifier().getValue()), cipherValue);
    }

    private void addAssistedQueryAssignment(String schemaName, String tableName, AssignmentSegment assignmentSegment, EncryptLiteralAssignmentToken token) {
        this.encryptRule.findAssistedQueryColumn(tableName, ((ColumnSegment)assignmentSegment.getColumns().get(0)).getIdentifier().getValue()).ifPresent(assistedQueryColumn -> {
            Object originalValue = ((LiteralExpressionSegment)assignmentSegment.getValue()).getLiterals();
            Object assistedQueryValue = this.encryptRule.getEncryptAssistedQueryValues(schemaName, tableName, ((ColumnSegment)assignmentSegment.getColumns().get(0)).getIdentifier().getValue(), Collections.singletonList(originalValue)).iterator().next();
            token.addAssignment((String)assistedQueryColumn, assistedQueryValue);
        });
    }

    private void addPlainAssignment(String tableName, AssignmentSegment assignmentSegment, EncryptLiteralAssignmentToken token) {
        Object originalValue = ((LiteralExpressionSegment)assignmentSegment.getValue()).getLiterals();
        this.encryptRule.findPlainColumn(tableName, ((ColumnSegment)assignmentSegment.getColumns().get(0)).getIdentifier().getValue()).ifPresent(plainColumn -> token.addAssignment((String)plainColumn, originalValue));
    }

    @Override
    @Generated
    public void setEncryptRule(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }

    @Override
    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }
}

