/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptConfigDataTypeToken;
import org.apache.shardingsphere.encrypt.rule.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.aware.EncryptRuleAware;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.ddl.CreateTableStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.RemoveToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.SubstitutableColumnNameToken;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateTableStatement;

public final class EncryptCreateTableTokenGenerator
implements CollectionSQLTokenGenerator<CreateTableStatementContext>,
EncryptRuleAware {
    private EncryptRule encryptRule;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof CreateTableStatementContext && !((CreateTableStatement)((CreateTableStatementContext)sqlStatementContext).getSqlStatement()).getColumnDefinitions().isEmpty();
    }

    public Collection<SQLToken> generateSQLTokens(CreateTableStatementContext createTableStatementContext) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        String tableName = ((CreateTableStatement)createTableStatementContext.getSqlStatement()).getTable().getTableName().getIdentifier().getValue();
        ArrayList<ColumnDefinitionSegment> columns = new ArrayList<ColumnDefinitionSegment>(((CreateTableStatement)createTableStatementContext.getSqlStatement()).getColumnDefinitions());
        for (int index = 0; index < columns.size(); ++index) {
            ColumnDefinitionSegment each = (ColumnDefinitionSegment)columns.get(index);
            String columnName = each.getColumnName().getIdentifier().getValue();
            Optional<EncryptAlgorithm> encryptor = this.encryptRule.findEncryptor(tableName, columnName);
            if (!encryptor.isPresent()) continue;
            result.addAll(this.getColumnTokens(tableName, columnName, each, columns, index));
        }
        return result;
    }

    private Collection<SQLToken> getColumnTokens(String tableName, String columnName, ColumnDefinitionSegment column, List<ColumnDefinitionSegment> columns, int index) {
        boolean lastColumn = columns.size() - 1 == index;
        int columnStopIndex = lastColumn ? column.getStopIndex() : columns.get(index + 1).getStartIndex() - 1;
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        result.add((SQLToken)new RemoveToken(column.getStartIndex(), columnStopIndex));
        result.add(this.getCipherColumnToken(tableName, columnName, column, columnStopIndex));
        this.getAssistedQueryColumnToken(tableName, columnName, column, columnStopIndex, lastColumn).ifPresent(result::add);
        this.getPlainColumnToken(tableName, columnName, column, columnStopIndex, lastColumn).ifPresent(result::add);
        return result;
    }

    private SQLToken getCipherColumnToken(String tableName, String columnName, ColumnDefinitionSegment column, int stopIndex) {
        Optional<EncryptConfigDataTypeToken> configDataTypeToken = this.findEncryptConfigDataTypeToken(tableName, columnName, column, stopIndex);
        return configDataTypeToken.isPresent() ? (SQLToken)configDataTypeToken.get() : new SubstitutableColumnNameToken(stopIndex + 1, column.getColumnName().getStopIndex(), this.getColumnProjections(this.encryptRule.getCipherColumn(tableName, columnName)));
    }

    private Optional<EncryptConfigDataTypeToken> findEncryptConfigDataTypeToken(String tableName, String columnName, ColumnDefinitionSegment column, int stopIndex) {
        Optional encryptColumn = this.encryptRule.findEncryptTable(tableName).flatMap(encryptTable -> encryptTable.findEncryptColumn(columnName));
        if (encryptColumn.isPresent() && null != ((EncryptColumn)encryptColumn.get()).getCipherDataType()) {
            return Optional.of(new EncryptConfigDataTypeToken(stopIndex + 1, column.getStopIndex(), ((EncryptColumn)encryptColumn.get()).getCipherColumn(), ((EncryptColumn)encryptColumn.get()).getCipherDataType().getTypeName()));
        }
        return Optional.empty();
    }

    private Optional<? extends SQLToken> getAssistedQueryColumnToken(String tableName, String columnName, ColumnDefinitionSegment column, int stopIndex, boolean lastColumn) {
        Optional<EncryptConfigDataTypeToken> encryptConfigDataTypeToken = this.findAssistedConfigDataTypeToken(tableName, columnName, column, stopIndex, lastColumn);
        if (encryptConfigDataTypeToken.isPresent()) {
            return encryptConfigDataTypeToken;
        }
        Optional<String> assistedQueryColumn = this.encryptRule.findAssistedQueryColumn(tableName, columnName);
        return assistedQueryColumn.map(optional -> new SubstitutableColumnNameToken(stopIndex + 1, column.getColumnName().getStopIndex(), this.getColumnProjections((String)optional), lastColumn));
    }

    private Optional<EncryptConfigDataTypeToken> findAssistedConfigDataTypeToken(String tableName, String columnName, ColumnDefinitionSegment column, int stopIndex, boolean lastColumn) {
        Optional encryptColumn = this.encryptRule.findEncryptTable(tableName).flatMap(encryptTable -> encryptTable.findEncryptColumn(columnName));
        Optional assistedQueryColumn = encryptColumn.flatMap(EncryptColumn::getAssistedQueryColumn);
        if (assistedQueryColumn.isPresent() && null != ((EncryptColumn)encryptColumn.get()).getAssistedQueryDataType()) {
            return Optional.of(new EncryptConfigDataTypeToken(stopIndex + 1, column.getStopIndex(), (String)assistedQueryColumn.get(), ((EncryptColumn)encryptColumn.get()).getAssistedQueryDataType().getTypeName(), lastColumn));
        }
        return Optional.empty();
    }

    private Optional<? extends SQLToken> getPlainColumnToken(String tableName, String columnName, ColumnDefinitionSegment column, int stopIndex, boolean lastColumn) {
        Optional<EncryptConfigDataTypeToken> encryptConfigDataTypeToken = this.findPlainConfigDataTypeToken(tableName, columnName, column, stopIndex, lastColumn);
        if (encryptConfigDataTypeToken.isPresent()) {
            return encryptConfigDataTypeToken;
        }
        Optional<String> plainColumn = this.encryptRule.findPlainColumn(tableName, columnName);
        return plainColumn.map(optional -> new SubstitutableColumnNameToken(stopIndex + 1, column.getColumnName().getStopIndex(), this.getColumnProjections((String)optional), lastColumn));
    }

    private Optional<EncryptConfigDataTypeToken> findPlainConfigDataTypeToken(String tableName, String columnName, ColumnDefinitionSegment column, int stopIndex, boolean lastColumn) {
        Optional encryptColumn = this.encryptRule.findEncryptTable(tableName).flatMap(encryptTable -> encryptTable.findEncryptColumn(columnName));
        Optional plainColumn = encryptColumn.flatMap(EncryptColumn::getPlainColumn);
        if (plainColumn.isPresent() && null != ((EncryptColumn)encryptColumn.get()).getPlainDataType()) {
            return Optional.of(new EncryptConfigDataTypeToken(stopIndex + 1, column.getStopIndex(), (String)plainColumn.get(), ((EncryptColumn)encryptColumn.get()).getPlainDataType().getTypeName(), lastColumn));
        }
        return Optional.empty();
    }

    private Collection<ColumnProjection> getColumnProjections(String columnName) {
        return Collections.singletonList(new ColumnProjection(null, columnName, null));
    }

    @Override
    @Generated
    public void setEncryptRule(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }
}

