/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptAlterTableToken;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptConfigDataTypeToken;
import org.apache.shardingsphere.encrypt.rule.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.aware.EncryptRuleAware;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.ddl.AlterTableStatementContext;
import org.apache.shardingsphere.infra.config.exception.ShardingSphereConfigurationException;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.Substitutable;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.RemoveToken;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.AddColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.ChangeColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.DropColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.ModifyColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.position.ColumnPositionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterTableStatement;

public final class EncryptAlterTableTokenGenerator
implements CollectionSQLTokenGenerator<AlterTableStatementContext>,
EncryptRuleAware {
    private EncryptRule encryptRule;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof AlterTableStatementContext;
    }

    public Collection<SQLToken> generateSQLTokens(AlterTableStatementContext alterTableStatementContext) {
        String tableName = ((AlterTableStatement)alterTableStatementContext.getSqlStatement()).getTable().getTableName().getIdentifier().getValue();
        LinkedList<SQLToken> result = new LinkedList<SQLToken>(this.getAddColumnTokens(tableName, ((AlterTableStatement)alterTableStatementContext.getSqlStatement()).getAddColumnDefinitions()));
        result.addAll(this.getModifyColumnTokens(tableName, ((AlterTableStatement)alterTableStatementContext.getSqlStatement()).getModifyColumnDefinitions()));
        result.addAll(this.getChangeColumnTokens(tableName, ((AlterTableStatement)alterTableStatementContext.getSqlStatement()).getChangeColumnDefinitions()));
        Collection<SQLToken> dropCollection = this.getDropColumnTokens(tableName, ((AlterTableStatement)alterTableStatementContext.getSqlStatement()).getDropColumnDefinitions());
        String databaseName = alterTableStatementContext.getDatabaseType().getName();
        if ("SQLServer".equals(databaseName)) {
            result.addAll(this.mergeDropColumnStatement(dropCollection, "", ""));
        } else if ("Oracle".equals(databaseName)) {
            result.addAll(this.mergeDropColumnStatement(dropCollection, "(", ")"));
        } else {
            result.addAll(dropCollection);
        }
        return result;
    }

    private Collection<SQLToken> mergeDropColumnStatement(Collection<SQLToken> dropCollection, String leftJoiner, String rightJoiner) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        ArrayList<String> dropColumnList = new ArrayList<String>();
        int lastStartIndex = -1;
        for (int i = 0; i < dropCollection.size(); ++i) {
            SQLToken token = (SQLToken)((List)dropCollection).get(i);
            if (token instanceof RemoveToken) {
                if (i != 0) {
                    result.add((SQLToken)new RemoveToken(lastStartIndex, ((RemoveToken)token).getStopIndex()));
                } else {
                    result.add(token);
                }
            } else {
                EncryptAlterTableToken encryptAlterTableToken = (EncryptAlterTableToken)token;
                dropColumnList.add(encryptAlterTableToken.getColumnName());
                if (i == dropCollection.size() - 1) {
                    result.add(new EncryptAlterTableToken(token.getStartIndex(), encryptAlterTableToken.getStopIndex(), leftJoiner + String.join((CharSequence)",", dropColumnList) + rightJoiner, "DROP COLUMN"));
                }
            }
            lastStartIndex = ((Substitutable)token).getStartIndex();
        }
        return result;
    }

    private Collection<SQLToken> getAddColumnTokens(String tableName, Collection<AddColumnDefinitionSegment> columnDefinitionSegments) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (AddColumnDefinitionSegment each : columnDefinitionSegments) {
            result.addAll(this.getAddColumnTokens(tableName, each));
        }
        return result;
    }

    private Collection<SQLToken> getAddColumnTokens(String tableName, AddColumnDefinitionSegment addColumnDefinitionSegment) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (ColumnDefinitionSegment each : addColumnDefinitionSegment.getColumnDefinitions()) {
            String columnName = each.getColumnName().getIdentifier().getValue();
            Optional<EncryptAlgorithm> encryptor = this.encryptRule.findEncryptor(tableName, columnName);
            if (!encryptor.isPresent()) continue;
            result.addAll(this.getAddColumnTokens(tableName, columnName, addColumnDefinitionSegment, each));
        }
        this.getAddColumnPositionToken(tableName, addColumnDefinitionSegment).ifPresent(result::add);
        return result;
    }

    private Collection<SQLToken> getAddColumnTokens(String tableName, String columnName, AddColumnDefinitionSegment addColumnDefinitionSegment, ColumnDefinitionSegment columnDefinitionSegment) {
        return this.encryptRule.containsConfigDataType(tableName, columnName) ? this.getAddColumnTokensWithConfigDataType(tableName, columnName, addColumnDefinitionSegment, columnDefinitionSegment) : this.getAddColumnTokensByDefault(tableName, columnName, addColumnDefinitionSegment, columnDefinitionSegment);
    }

    private Collection<SQLToken> getAddColumnTokensByDefault(String tableName, String columnName, AddColumnDefinitionSegment addColumnDefinitionSegment, ColumnDefinitionSegment columnDefinitionSegment) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        result.add((SQLToken)new RemoveToken(columnDefinitionSegment.getStartIndex(), columnDefinitionSegment.getColumnName().getStopIndex()));
        result.add(new EncryptAlterTableToken(columnDefinitionSegment.getColumnName().getStopIndex() + 1, columnDefinitionSegment.getColumnName().getStopIndex(), this.encryptRule.getCipherColumn(tableName, columnName), null));
        Optional<String> assistedQueryColumn = this.encryptRule.findAssistedQueryColumn(tableName, columnName);
        assistedQueryColumn.map(optional -> new EncryptAlterTableToken(addColumnDefinitionSegment.getStopIndex() + 1, columnDefinitionSegment.getColumnName().getStopIndex(), (String)optional, ", ADD COLUMN")).ifPresent(result::add);
        Optional<String> plainColumn = this.encryptRule.findPlainColumn(tableName, columnName);
        plainColumn.map(optional -> new EncryptAlterTableToken(addColumnDefinitionSegment.getStopIndex() + 1, columnDefinitionSegment.getColumnName().getStopIndex(), (String)optional, ", ADD COLUMN")).ifPresent(result::add);
        return result;
    }

    private Collection<SQLToken> getAddColumnTokensWithConfigDataType(String tableName, String columnName, AddColumnDefinitionSegment addColumnDefinitionSegment, ColumnDefinitionSegment columnDefinitionSegment) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        EncryptColumn encryptColumn = this.getEncryptColumn(tableName, columnName);
        result.add((SQLToken)new RemoveToken(columnDefinitionSegment.getStartIndex(), columnDefinitionSegment.getStopIndex()));
        result.add(new EncryptConfigDataTypeToken(columnDefinitionSegment.getStopIndex() + 1, columnDefinitionSegment.getStopIndex(), this.encryptRule.getCipherColumn(tableName, columnName), encryptColumn.getCipherDataType().getTypeName()));
        Optional<String> assistedQueryColumn = this.encryptRule.findAssistedQueryColumn(tableName, columnName);
        assistedQueryColumn.map(assisted -> new EncryptConfigDataTypeToken(addColumnDefinitionSegment.getStopIndex() + 1, addColumnDefinitionSegment.getStopIndex(), ", ADD COLUMN " + assisted, encryptColumn.getAssistedQueryDataType().getTypeName())).ifPresent(result::add);
        Optional<String> plainColumn = this.encryptRule.findPlainColumn(tableName, columnName);
        plainColumn.map(plain -> new EncryptConfigDataTypeToken(addColumnDefinitionSegment.getStopIndex() + 1, addColumnDefinitionSegment.getStopIndex(), ", ADD COLUMN " + plain, encryptColumn.getPlainDataType().getTypeName())).ifPresent(result::add);
        return result;
    }

    private EncryptColumn getEncryptColumn(String tableName, String columnName) {
        return this.encryptRule.findEncryptColumn(tableName, columnName).orElseThrow(() -> new ShardingSphereConfigurationException("Failed finding encrypt column.", new Object[0]));
    }

    private Optional<SQLToken> getAddColumnPositionToken(String tableName, AddColumnDefinitionSegment addColumnDefinitionSegment) {
        Optional encryptor = addColumnDefinitionSegment.getColumnPosition().filter(positionSegment -> null != positionSegment.getColumnName()).flatMap(positionSegment -> this.encryptRule.findEncryptor(tableName, positionSegment.getColumnName().getIdentifier().getValue()));
        if (encryptor.isPresent()) {
            return Optional.of(this.getPositionColumnToken((ColumnPositionSegment)addColumnDefinitionSegment.getColumnPosition().get(), tableName));
        }
        return Optional.empty();
    }

    private EncryptAlterTableToken getPositionColumnToken(ColumnPositionSegment positionSegment, String tableName) {
        return new EncryptAlterTableToken(positionSegment.getColumnName().getStartIndex(), positionSegment.getStopIndex(), this.encryptRule.getCipherColumn(tableName, positionSegment.getColumnName().getIdentifier().getValue()), null);
    }

    private Collection<SQLToken> getModifyColumnTokens(String tableName, Collection<ModifyColumnDefinitionSegment> columnDefinitionSegments) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (ModifyColumnDefinitionSegment each : columnDefinitionSegments) {
            ColumnDefinitionSegment segment = each.getColumnDefinition();
            String columnName = segment.getColumnName().getIdentifier().getValue();
            Optional<EncryptAlgorithm> encryptor = this.encryptRule.findEncryptor(tableName, columnName);
            if (encryptor.isPresent()) {
                result.addAll(this.getModifyColumnTokens(tableName, columnName, each));
            }
            each.getColumnPosition().flatMap(columnPositionSegment -> this.getColumnPositionToken(tableName, (ColumnPositionSegment)columnPositionSegment)).ifPresent(result::add);
        }
        return result;
    }

    private Collection<SQLToken> getModifyColumnTokens(String tableName, String columnName, ModifyColumnDefinitionSegment modifyColumnDefinitionSegment) {
        return this.encryptRule.containsConfigDataType(tableName, columnName) ? this.getModifyColumnTokensWithConfigDataType(tableName, columnName, modifyColumnDefinitionSegment) : this.getModifyColumnTokensByDefault(tableName, columnName, modifyColumnDefinitionSegment);
    }

    private Collection<SQLToken> getModifyColumnTokensWithConfigDataType(String tableName, String columnName, ModifyColumnDefinitionSegment segment) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        ColumnDefinitionSegment columnDefinitionSegment = segment.getColumnDefinition();
        EncryptColumn encryptColumn = this.getEncryptColumn(tableName, columnName);
        result.add((SQLToken)new RemoveToken(columnDefinitionSegment.getColumnName().getStartIndex(), columnDefinitionSegment.getStopIndex()));
        result.add(new EncryptConfigDataTypeToken(columnDefinitionSegment.getStopIndex() + 1, columnDefinitionSegment.getStopIndex(), this.encryptRule.getCipherColumn(tableName, columnName), encryptColumn.getCipherDataType().getTypeName()));
        this.encryptRule.findAssistedQueryColumn(tableName, columnName).map(assist -> new EncryptConfigDataTypeToken(segment.getStopIndex() + 1, segment.getStopIndex(), ", MODIFY COLUMN " + assist, encryptColumn.getAssistedQueryDataType().getTypeName())).ifPresent(result::add);
        this.encryptRule.findPlainColumn(tableName, columnName).map(plain -> new EncryptConfigDataTypeToken(segment.getStopIndex() + 1, segment.getStopIndex(), ", MODIFY COLUMN " + plain, encryptColumn.getPlainDataType().getTypeName())).ifPresent(result::add);
        return result;
    }

    private Collection<SQLToken> getModifyColumnTokensByDefault(String tableName, String columnName, ModifyColumnDefinitionSegment modifyColumnDefinitionSegment) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        ColumnDefinitionSegment columnDefinitionSegment = modifyColumnDefinitionSegment.getColumnDefinition();
        result.add((SQLToken)new RemoveToken(columnDefinitionSegment.getColumnName().getStartIndex(), columnDefinitionSegment.getColumnName().getStopIndex()));
        result.add(new EncryptAlterTableToken(columnDefinitionSegment.getColumnName().getStopIndex() + 1, columnDefinitionSegment.getColumnName().getStopIndex(), this.encryptRule.getCipherColumn(tableName, columnName), null));
        this.encryptRule.findAssistedQueryColumn(tableName, columnName).map(optional -> new EncryptAlterTableToken(modifyColumnDefinitionSegment.getStopIndex() + 1, columnDefinitionSegment.getColumnName().getStopIndex(), (String)optional, ", MODIFY COLUMN")).ifPresent(result::add);
        this.encryptRule.findPlainColumn(tableName, columnName).map(optional -> new EncryptAlterTableToken(modifyColumnDefinitionSegment.getStopIndex() + 1, columnDefinitionSegment.getColumnName().getStopIndex(), (String)optional, ", MODIFY COLUMN")).ifPresent(result::add);
        return result;
    }

    private Optional<SQLToken> getColumnPositionToken(String tableName, ColumnPositionSegment columnPositionSegment) {
        Optional encryptor = Optional.of(columnPositionSegment).filter(positionSegment -> null != positionSegment.getColumnName()).flatMap(positionSegment -> this.encryptRule.findEncryptor(tableName, positionSegment.getColumnName().getIdentifier().getValue()));
        if (encryptor.isPresent()) {
            return Optional.of(this.getPositionColumnToken(columnPositionSegment, tableName));
        }
        return Optional.empty();
    }

    private Collection<SQLToken> getChangeColumnTokens(String tableName, Collection<ChangeColumnDefinitionSegment> changeColumnDefinitions) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (ChangeColumnDefinitionSegment each : changeColumnDefinitions) {
            result.addAll(this.getChangeColumnTokensEach(tableName, each));
            each.getColumnPosition().flatMap(columnPositionSegment -> this.getColumnPositionToken(tableName, (ColumnPositionSegment)columnPositionSegment)).ifPresent(result::add);
        }
        return result;
    }

    private Collection<? extends SQLToken> getChangeColumnTokensEach(String tableName, ChangeColumnDefinitionSegment segment) {
        this.isSameEncryptColumn(tableName, segment);
        if (!this.encryptRule.findEncryptor(tableName, segment.getPreviousColumn().getIdentifier().getValue()).isPresent() || !this.encryptRule.findEncryptor(tableName, segment.getColumnDefinition().getColumnName().getIdentifier().getValue()).isPresent()) {
            return Collections.emptyList();
        }
        LinkedList<Object> result = new LinkedList<Object>();
        result.addAll(this.getPreviousColumnTokens(tableName, segment));
        result.addAll(this.getColumnTokens(tableName, segment));
        return result;
    }

    private void isSameEncryptColumn(String tableName, ChangeColumnDefinitionSegment segment) {
        Optional<EncryptAlgorithm> previousAlgorithm = this.encryptRule.findEncryptor(tableName, segment.getPreviousColumn().getIdentifier().getValue());
        Optional<EncryptAlgorithm> currentAlgorithm = this.encryptRule.findEncryptor(tableName, segment.getColumnDefinition().getColumnName().getIdentifier().getValue());
        if (!previousAlgorithm.isPresent() && !currentAlgorithm.isPresent()) {
            return;
        }
        if (previousAlgorithm.isPresent() && currentAlgorithm.isPresent() && previousAlgorithm.get().equals(currentAlgorithm.get()) && this.checkPreviousAndAfterHasSameColumnNumber(tableName, segment)) {
            return;
        }
        throw new ShardingSphereException("Alter change column statement's columns must both have same encrypt algorithm!", new Object[0]);
    }

    private boolean checkPreviousAndAfterHasSameColumnNumber(String tableName, ChangeColumnDefinitionSegment segment) {
        EncryptColumn previousColumn = this.getEncryptColumn(tableName, segment.getPreviousColumn().getIdentifier().getValue());
        EncryptColumn currentColumn = this.getEncryptColumn(tableName, segment.getColumnDefinition().getColumnName().getIdentifier().getValue());
        if (previousColumn.getPlainColumn().isPresent() && !currentColumn.getPlainColumn().isPresent()) {
            return false;
        }
        if (!previousColumn.getPlainColumn().isPresent() && currentColumn.getPlainColumn().isPresent()) {
            return false;
        }
        if (previousColumn.getAssistedQueryColumn().isPresent() && !currentColumn.getAssistedQueryColumn().isPresent()) {
            return false;
        }
        return previousColumn.getAssistedQueryColumn().isPresent() || !currentColumn.getAssistedQueryColumn().isPresent();
    }

    private Collection<? extends SQLToken> getColumnTokens(String tableName, ChangeColumnDefinitionSegment segment) {
        return this.encryptRule.containsConfigDataType(tableName, segment.getColumnDefinition().getColumnName().getIdentifier().getValue()) ? this.getChangeColumnTokensWithConfigDataType(tableName, segment) : this.getChangeColumnTokensByDefault(tableName, segment);
    }

    private Collection<? extends SQLToken> getChangeColumnTokensWithConfigDataType(String tableName, ChangeColumnDefinitionSegment segment) {
        LinkedList<Object> result = new LinkedList<Object>();
        result.add(new RemoveToken(segment.getColumnDefinition().getColumnName().getStartIndex(), segment.getColumnDefinition().getStopIndex()));
        EncryptColumn encryptColumn = this.getEncryptColumn(tableName, segment.getColumnDefinition().getColumnName().getIdentifier().getValue());
        result.add((Object)new EncryptConfigDataTypeToken(segment.getColumnDefinition().getStopIndex() + 1, segment.getColumnDefinition().getStopIndex(), encryptColumn.getCipherColumn(), encryptColumn.getCipherDataType().getTypeName()));
        String previousColumnName = segment.getPreviousColumn().getIdentifier().getValue();
        this.encryptRule.findAssistedQueryColumn(tableName, previousColumnName).map(optional -> new EncryptConfigDataTypeToken(segment.getStopIndex() + 1, segment.getStopIndex(), ", CHANGE COLUMN " + optional + " " + encryptColumn.getAssistedQueryColumn().orElse(""), encryptColumn.getAssistedQueryDataType().getTypeName())).ifPresent(result::add);
        this.encryptRule.findPlainColumn(tableName, previousColumnName).map(optional -> new EncryptConfigDataTypeToken(segment.getStopIndex() + 1, segment.getStopIndex(), ", CHANGE COLUMN " + optional + " " + encryptColumn.getPlainColumn().orElse(""), encryptColumn.getPlainDataType().getTypeName())).ifPresent(result::add);
        return result;
    }

    private Collection<SQLToken> getChangeColumnTokensByDefault(String tableName, ChangeColumnDefinitionSegment segment) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        result.add((SQLToken)new RemoveToken(segment.getColumnDefinition().getColumnName().getStartIndex(), segment.getColumnDefinition().getColumnName().getStopIndex()));
        result.add(new EncryptAlterTableToken(segment.getColumnDefinition().getColumnName().getStopIndex() + 1, segment.getColumnDefinition().getColumnName().getStopIndex(), this.encryptRule.getCipherColumn(tableName, segment.getColumnDefinition().getColumnName().getIdentifier().getValue()), null));
        String previousColumnName = segment.getPreviousColumn().getIdentifier().getValue();
        EncryptColumn encryptColumn = this.getEncryptColumn(tableName, segment.getColumnDefinition().getColumnName().getIdentifier().getValue());
        this.encryptRule.findAssistedQueryColumn(tableName, previousColumnName).map(optional -> new EncryptAlterTableToken(segment.getStopIndex() + 1, segment.getColumnDefinition().getColumnName().getStopIndex(), encryptColumn.getAssistedQueryColumn().orElse(""), ", CHANGE COLUMN " + optional)).ifPresent(result::add);
        this.encryptRule.findPlainColumn(tableName, previousColumnName).map(optional -> new EncryptAlterTableToken(segment.getStopIndex() + 1, segment.getColumnDefinition().getColumnName().getStopIndex(), encryptColumn.getPlainColumn().orElse(""), ", CHANGE COLUMN " + optional)).ifPresent(result::add);
        return result;
    }

    private Collection<? extends SQLToken> getPreviousColumnTokens(String tableName, ChangeColumnDefinitionSegment segment) {
        LinkedList<Object> result = new LinkedList<Object>();
        result.add(new RemoveToken(segment.getPreviousColumn().getStartIndex(), segment.getPreviousColumn().getStopIndex()));
        result.add((Object)new EncryptAlterTableToken(segment.getPreviousColumn().getStopIndex() + 1, segment.getPreviousColumn().getStopIndex(), this.encryptRule.getCipherColumn(tableName, segment.getPreviousColumn().getIdentifier().getValue()), null));
        return result;
    }

    private Collection<SQLToken> getDropColumnTokens(String tableName, Collection<DropColumnDefinitionSegment> columnDefinitionSegments) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (DropColumnDefinitionSegment each : columnDefinitionSegments) {
            result.addAll(this.getDropColumnTokens(tableName, each));
        }
        return result;
    }

    private Collection<SQLToken> getDropColumnTokens(String tableName, DropColumnDefinitionSegment dropColumnDefinitionSegment) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (ColumnSegment each : dropColumnDefinitionSegment.getColumns()) {
            String columnName = each.getQualifiedName();
            Optional<EncryptAlgorithm> encryptor = this.encryptRule.findEncryptor(tableName, columnName);
            if (!encryptor.isPresent()) continue;
            result.addAll(this.getDropColumnTokens(tableName, columnName, each, dropColumnDefinitionSegment));
        }
        return result;
    }

    private Collection<SQLToken> getDropColumnTokens(String tableName, String columnName, ColumnSegment columnSegment, DropColumnDefinitionSegment dropColumnDefinitionSegment) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        result.add((SQLToken)new RemoveToken(columnSegment.getStartIndex(), columnSegment.getStopIndex()));
        result.add(new EncryptAlterTableToken(columnSegment.getStopIndex() + 1, columnSegment.getStopIndex(), this.encryptRule.getCipherColumn(tableName, columnName), null));
        this.encryptRule.findAssistedQueryColumn(tableName, columnName).map(optional -> new EncryptAlterTableToken(dropColumnDefinitionSegment.getStopIndex() + 1, dropColumnDefinitionSegment.getStopIndex(), (String)optional, ", DROP COLUMN")).ifPresent(result::add);
        this.encryptRule.findPlainColumn(tableName, columnName).map(optional -> new EncryptAlterTableToken(dropColumnDefinitionSegment.getStopIndex() + 1, dropColumnDefinitionSegment.getStopIndex(), (String)optional, ", DROP COLUMN")).ifPresent(result::add);
        return result;
    }

    @Override
    @Generated
    public void setEncryptRule(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }
}

