/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.EncryptConditionsAware;
import org.apache.shardingsphere.encrypt.rewrite.aware.SchemaNameAware;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptCondition;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.AssistQueryAndPlainInsertColumnsTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.EncryptAlterTableTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.EncryptAssignmentTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.EncryptCreateTableTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.EncryptForUseDefaultInsertColumnsTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.EncryptInsertOnUpdateTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.EncryptInsertValuesTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.EncryptOrderByItemTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.EncryptPredicateColumnTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.EncryptPredicateRightValueTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.EncryptProjectionTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.InsertCipherNameTokenGenerator;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.aware.EncryptRuleAware;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.SQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.builder.SQLTokenGeneratorBuilder;

public final class EncryptTokenGenerateBuilder
implements SQLTokenGeneratorBuilder {
    private final EncryptRule encryptRule;
    private final SQLStatementContext<?> sqlStatementContext;
    private final Collection<EncryptCondition> encryptConditions;
    private final String schemaName;

    public Collection<SQLTokenGenerator> getSQLTokenGenerators() {
        LinkedList<SQLTokenGenerator> result = new LinkedList<SQLTokenGenerator>();
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptProjectionTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptAssignmentTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptPredicateColumnTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptPredicateRightValueTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptInsertValuesTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptForUseDefaultInsertColumnsTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new InsertCipherNameTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new AssistQueryAndPlainInsertColumnsTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptInsertOnUpdateTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptCreateTableTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptAlterTableTokenGenerator());
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptOrderByItemTokenGenerator());
        return result;
    }

    private void addSQLTokenGenerator(Collection<SQLTokenGenerator> sqlTokenGenerators, SQLTokenGenerator toBeAddedSQLTokenGenerator) {
        if (toBeAddedSQLTokenGenerator.isGenerateSQLToken(this.sqlStatementContext)) {
            this.setUpSQLTokenGenerator(toBeAddedSQLTokenGenerator);
            sqlTokenGenerators.add(toBeAddedSQLTokenGenerator);
        }
    }

    private void setUpSQLTokenGenerator(SQLTokenGenerator toBeAddedSQLTokenGenerator) {
        if (toBeAddedSQLTokenGenerator instanceof EncryptRuleAware) {
            ((EncryptRuleAware)toBeAddedSQLTokenGenerator).setEncryptRule(this.encryptRule);
        }
        if (toBeAddedSQLTokenGenerator instanceof EncryptConditionsAware) {
            ((EncryptConditionsAware)toBeAddedSQLTokenGenerator).setEncryptConditions(this.encryptConditions);
        }
        if (toBeAddedSQLTokenGenerator instanceof SchemaNameAware) {
            ((SchemaNameAware)toBeAddedSQLTokenGenerator).setSchemaName(this.schemaName);
        }
    }

    @Generated
    public EncryptTokenGenerateBuilder(EncryptRule encryptRule, SQLStatementContext<?> sqlStatementContext, Collection<EncryptCondition> encryptConditions, String schemaName) {
        this.encryptRule = encryptRule;
        this.sqlStatementContext = sqlStatementContext;
        this.encryptConditions = encryptConditions;
        this.schemaName = schemaName;
    }
}

