/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.parameter.rewriter;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.context.EncryptContextBuilder;
import org.apache.shardingsphere.encrypt.rewrite.aware.SchemaNameAware;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.aware.EncryptRuleAware;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.encrypt.spi.QueryAssistedEncryptAlgorithm;
import org.apache.shardingsphere.encrypt.spi.context.EncryptContext;
import org.apache.shardingsphere.infra.binder.segment.insert.values.OnDuplicateUpdateContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.GroupedParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.InsertStatementHandler;

public final class EncryptInsertOnDuplicateKeyUpdateValueParameterRewriter
implements ParameterRewriter<InsertStatementContext>,
EncryptRuleAware,
SchemaNameAware {
    private EncryptRule encryptRule;
    private String schemaName;

    public boolean isNeedRewrite(SQLStatementContext<?> sqlStatementContext) {
        return sqlStatementContext instanceof InsertStatementContext && InsertStatementHandler.getOnDuplicateKeyColumnsSegment((InsertStatement)((InsertStatement)((InsertStatementContext)sqlStatementContext).getSqlStatement())).isPresent();
    }

    public void rewrite(ParameterBuilder parameterBuilder, InsertStatementContext insertStatementContext, List<Object> parameters) {
        String tableName = ((InsertStatement)insertStatementContext.getSqlStatement()).getTable().getTableName().getIdentifier().getValue();
        GroupedParameterBuilder groupedParameterBuilder = (GroupedParameterBuilder)parameterBuilder;
        OnDuplicateUpdateContext onDuplicateKeyUpdateValueContext = insertStatementContext.getOnDuplicateKeyUpdateValueContext();
        int index = 0;
        while (index < onDuplicateKeyUpdateValueContext.getValueExpressions().size()) {
            int columnIndex = index++;
            String encryptLogicColumnName = onDuplicateKeyUpdateValueContext.getColumn(columnIndex).getIdentifier().getValue();
            EncryptContext encryptContext = EncryptContextBuilder.build(this.schemaName, tableName, encryptLogicColumnName, this.encryptRule);
            Optional<EncryptAlgorithm> encryptor = this.encryptRule.findEncryptor(tableName, encryptLogicColumnName);
            encryptor.ifPresent(optional -> {
                Object plainColumnValue = onDuplicateKeyUpdateValueContext.getValue(columnIndex);
                if (plainColumnValue instanceof FunctionSegment && "VALUES".equalsIgnoreCase(((FunctionSegment)plainColumnValue).getFunctionName())) {
                    return;
                }
                Object cipherColumnValue = ((EncryptAlgorithm)encryptor.get()).encrypt(plainColumnValue, encryptContext);
                groupedParameterBuilder.getGenericParameterBuilder().addReplacedParameters(columnIndex, cipherColumnValue);
                LinkedList<Object> addedParameters = new LinkedList<Object>();
                if (optional instanceof QueryAssistedEncryptAlgorithm) {
                    Optional<String> assistedColumnName = this.encryptRule.findAssistedQueryColumn(tableName, encryptLogicColumnName);
                    Preconditions.checkArgument((boolean)assistedColumnName.isPresent(), (Object)"Can not find assisted query Column Name");
                    addedParameters.add(((QueryAssistedEncryptAlgorithm)optional).queryAssistedEncrypt(plainColumnValue, encryptContext));
                }
                if (this.encryptRule.findPlainColumn(tableName, encryptLogicColumnName).isPresent()) {
                    addedParameters.add(plainColumnValue);
                }
                if (!addedParameters.isEmpty()) {
                    if (!groupedParameterBuilder.getGenericParameterBuilder().getAddedIndexAndParameters().containsKey(columnIndex + 1)) {
                        groupedParameterBuilder.getGenericParameterBuilder().getAddedIndexAndParameters().put(columnIndex + 1, new LinkedList());
                    }
                    ((Collection)groupedParameterBuilder.getGenericParameterBuilder().getAddedIndexAndParameters().get(columnIndex + 1)).addAll(addedParameters);
                }
            });
        }
    }

    @Override
    @Generated
    public void setEncryptRule(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }

    @Override
    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }
}

