/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.context;

import java.util.Collection;
import java.util.Collections;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptCondition;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptConditionEngine;
import org.apache.shardingsphere.encrypt.rewrite.parameter.EncryptParameterRewriterBuilder;
import org.apache.shardingsphere.encrypt.rewrite.token.EncryptTokenGenerateBuilder;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.WhereAvailable;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.rewrite.context.SQLRewriteContext;
import org.apache.shardingsphere.infra.rewrite.context.SQLRewriteContextDecorator;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriter;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.SQLTokenGenerator;
import org.apache.shardingsphere.infra.route.context.RouteContext;

public final class EncryptSQLRewriteContextDecorator
implements SQLRewriteContextDecorator<EncryptRule> {
    public void decorate(EncryptRule encryptRule, ConfigurationProperties props, SQLRewriteContext sqlRewriteContext, RouteContext routeContext) {
        Collection<EncryptCondition> encryptConditions = this.getEncryptConditions(encryptRule, sqlRewriteContext);
        SQLStatementContext sqlStatementContext = sqlRewriteContext.getSqlStatementContext();
        boolean containsEncryptTable = this.containsEncryptTable(encryptRule, sqlStatementContext);
        encryptRule.setUpEncryptorSchema(sqlRewriteContext.getSchema());
        if (containsEncryptTable && !sqlRewriteContext.getParameters().isEmpty()) {
            Collection<ParameterRewriter> parameterRewriters = new EncryptParameterRewriterBuilder(encryptRule, sqlRewriteContext.getSchemaName(), sqlRewriteContext.getSchema(), sqlStatementContext, encryptConditions).getParameterRewriters();
            this.rewriteParameters(sqlRewriteContext, parameterRewriters);
        }
        if (containsEncryptTable) {
            Collection<SQLTokenGenerator> sqlTokenGenerators = new EncryptTokenGenerateBuilder(encryptRule, sqlStatementContext, encryptConditions, sqlRewriteContext.getSchemaName()).getSQLTokenGenerators();
            sqlRewriteContext.addSQLTokenGenerators(sqlTokenGenerators);
        }
    }

    private Collection<EncryptCondition> getEncryptConditions(EncryptRule encryptRule, SQLRewriteContext sqlRewriteContext) {
        SQLStatementContext sqlStatementContext = sqlRewriteContext.getSqlStatementContext();
        if (!(sqlStatementContext instanceof WhereAvailable)) {
            return Collections.emptyList();
        }
        Collection whereSegments = ((WhereAvailable)sqlStatementContext).getWhereSegments();
        Collection columnSegments = ((WhereAvailable)sqlStatementContext).getColumnSegments();
        return new EncryptConditionEngine(encryptRule, sqlRewriteContext.getSchema()).createEncryptConditions(whereSegments, columnSegments, sqlStatementContext.getTablesContext());
    }

    private boolean containsEncryptTable(EncryptRule encryptRule, SQLStatementContext sqlStatementContext) {
        for (String each : sqlStatementContext.getTablesContext().getTableNames()) {
            if (!encryptRule.findEncryptTable(each).isPresent()) continue;
            return true;
        }
        return false;
    }

    private void rewriteParameters(SQLRewriteContext sqlRewriteContext, Collection<ParameterRewriter> parameterRewriters) {
        for (ParameterRewriter each : parameterRewriters) {
            each.rewrite(sqlRewriteContext.getParameterBuilder(), sqlRewriteContext.getSqlStatementContext(), sqlRewriteContext.getParameters());
        }
    }

    public int getOrder() {
        return 10;
    }

    public Class<EncryptRule> getTypeClass() {
        return EncryptRule.class;
    }
}

