/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.metadata;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.shardingsphere.encrypt.rule.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.EncryptTable;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.schema.builder.SchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.schema.builder.spi.RuleBasedTableMetaDataBuilder;
import org.apache.shardingsphere.infra.metadata.schema.loader.TableMetaDataLoaderEngine;
import org.apache.shardingsphere.infra.metadata.schema.model.ColumnMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.infra.metadata.schema.util.TableMetaDataUtil;

public final class EncryptTableMetaDataBuilder
implements RuleBasedTableMetaDataBuilder<EncryptRule> {
    public Map<String, TableMetaData> load(Collection<String> tableNames, EncryptRule rule, SchemaBuilderMaterials materials) throws SQLException {
        Collection needLoadTables = tableNames.stream().filter(each -> rule.findEncryptTable((String)each).isPresent()).collect(Collectors.toList());
        if (needLoadTables.isEmpty()) {
            return Collections.emptyMap();
        }
        Collection tableMetaDataLoaderMaterials = TableMetaDataUtil.getTableMetaDataLoadMaterial((Collection)needLoadTables, (SchemaBuilderMaterials)materials, (boolean)false);
        if (tableMetaDataLoaderMaterials.isEmpty()) {
            return Collections.emptyMap();
        }
        Collection tableMetaDataList = TableMetaDataLoaderEngine.load((Collection)tableMetaDataLoaderMaterials, (DatabaseType)materials.getDatabaseType());
        return tableMetaDataList.stream().collect(Collectors.toMap(TableMetaData::getName, Function.identity(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    public Map<String, TableMetaData> decorate(Map<String, TableMetaData> tableMetaDataMap, EncryptRule rule, SchemaBuilderMaterials materials) throws SQLException {
        LinkedHashMap<String, TableMetaData> result = new LinkedHashMap<String, TableMetaData>();
        for (Map.Entry<String, TableMetaData> entry : tableMetaDataMap.entrySet()) {
            result.put(entry.getKey(), this.decorate(entry.getKey(), entry.getValue(), rule));
        }
        return result;
    }

    private TableMetaData decorate(String tableName, TableMetaData tableMetaData, EncryptRule encryptRule) {
        Optional<EncryptTable> encryptTable = encryptRule.findEncryptTable(tableName);
        return encryptTable.map(optional -> new TableMetaData(tableName, this.getEncryptColumnMetaDataList((EncryptTable)optional, tableMetaData.getColumns().values()), tableMetaData.getIndexes().values(), tableMetaData.getConstrains().values())).orElse(tableMetaData);
    }

    private Collection<ColumnMetaData> getEncryptColumnMetaDataList(EncryptTable encryptTable, Collection<ColumnMetaData> originalColumnMetaDataList) {
        LinkedList<ColumnMetaData> result = new LinkedList<ColumnMetaData>();
        Collection<String> plainColumns = encryptTable.getPlainColumns();
        Collection<String> assistedQueryColumns = encryptTable.getAssistedQueryColumns();
        for (ColumnMetaData each : originalColumnMetaDataList) {
            String columnName = each.getName();
            if (encryptTable.isCipherColumn(columnName)) {
                result.add(this.createColumnMetaData(encryptTable.getLogicColumn(columnName), each, encryptTable));
                continue;
            }
            if (plainColumns.contains(columnName) || assistedQueryColumns.contains(columnName)) continue;
            result.add(each);
        }
        return result;
    }

    private ColumnMetaData createColumnMetaData(String columnName, ColumnMetaData columnMetaData, EncryptTable encryptTable) {
        Optional<EncryptColumn> encryptColumn = encryptTable.findEncryptColumn(columnName);
        if (encryptColumn.isPresent() && null != encryptColumn.get().getLogicDataType()) {
            return new ColumnMetaData(columnName, encryptColumn.get().getLogicDataType().getDataType(), columnMetaData.isPrimaryKey(), columnMetaData.isGenerated(), columnMetaData.isCaseSensitive());
        }
        return new ColumnMetaData(columnName, columnMetaData.getDataType(), columnMetaData.isPrimaryKey(), columnMetaData.isGenerated(), columnMetaData.isCaseSensitive());
    }

    public int getOrder() {
        return 10;
    }

    public Class<EncryptRule> getTypeClass() {
        return EncryptRule.class;
    }
}

