/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.merge.dql;

import java.io.InputStream;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.merge.dql.EncryptAlgorithmMetaData;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.encrypt.spi.context.EncryptContext;
import org.apache.shardingsphere.infra.merge.result.MergedResult;

public final class EncryptMergedResult
implements MergedResult {
    private final EncryptAlgorithmMetaData metaData;
    private final MergedResult mergedResult;

    public boolean next() throws SQLException {
        return this.mergedResult.next();
    }

    public Object getValue(int columnIndex, Class<?> type) throws SQLException {
        Optional<EncryptContext> encryptContext = this.metaData.findEncryptContext(columnIndex);
        if (!encryptContext.isPresent() || !this.metaData.isQueryWithCipherColumn(encryptContext.get().getTableName())) {
            return this.mergedResult.getValue(columnIndex, type);
        }
        Optional<EncryptAlgorithm> encryptAlgorithm = this.metaData.findEncryptor(encryptContext.get().getTableName(), encryptContext.get().getColumnName());
        if (!encryptAlgorithm.isPresent()) {
            return this.mergedResult.getValue(columnIndex, type);
        }
        Object cipherValue = this.mergedResult.getValue(columnIndex, Object.class);
        return null == cipherValue ? null : encryptAlgorithm.get().decrypt(cipherValue, encryptContext.get());
    }

    public Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) throws SQLException {
        return this.mergedResult.getCalendarValue(columnIndex, type, calendar);
    }

    public InputStream getInputStream(int columnIndex, String type) throws SQLException {
        return this.mergedResult.getInputStream(columnIndex, type);
    }

    public boolean wasNull() throws SQLException {
        return this.mergedResult.wasNull();
    }

    @Generated
    public EncryptMergedResult(EncryptAlgorithmMetaData metaData, MergedResult mergedResult) {
        this.metaData = metaData;
        this.mergedResult = mergedResult;
    }
}

