/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.context;

import org.apache.shardingsphere.encrypt.rule.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.spi.context.EncryptContext;

public final class EncryptContextBuilder {
    public static EncryptContext build(String schemaName, String tableName, String columnName, EncryptRule encryptRule) {
        EncryptContext result = new EncryptContext(schemaName, tableName, columnName);
        encryptRule.findEncryptTable(tableName).flatMap(optional -> optional.findEncryptColumn(columnName)).ifPresent(optional -> EncryptContextBuilder.setEncryptDataType(result, optional));
        return result;
    }

    private static void setEncryptDataType(EncryptContext result, EncryptColumn encryptColumn) {
        result.setLogicDataType(encryptColumn.getLogicDataType());
        result.setPlainDataType(encryptColumn.getPlainDataType());
        result.setCipherDataType(encryptColumn.getCipherDataType());
        result.setAssistedQueryDataType(encryptColumn.getAssistedQueryDataType());
    }
}

