/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.algorithm;

import com.google.common.base.Preconditions;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import lombok.Generated;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.encrypt.spi.context.EncryptContext;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

public final class SM3EncryptAlgorithm
implements EncryptAlgorithm<Object, String> {
    private static final String SM3_SALT = "sm3-salt";
    private static final int SALT_LENGTH = 8;
    private Properties props = new Properties();
    private byte[] sm3Salt;

    public void init() {
        this.sm3Salt = this.createSm3Salt();
    }

    private byte[] createSm3Salt() {
        String salt = null == this.props.getProperty(SM3_SALT) ? "" : String.valueOf(this.props.getProperty(SM3_SALT));
        Preconditions.checkState((0 == salt.length() || 8 == salt.length() ? 1 : 0) != 0, (Object)"Salt should be either blank or better 8 bytes long.");
        return 0 == salt.length() ? new byte[]{} : StringUtils.getBytesUtf8((String)salt);
    }

    public String encrypt(Object plainValue, EncryptContext encryptContext) {
        if (null == plainValue) {
            return null;
        }
        return ByteUtils.toHexString((byte[])this.digest(StringUtils.getBytesUtf8((String)String.valueOf(plainValue)), this.sm3Salt));
    }

    public Object decrypt(String cipherValue, EncryptContext encryptContext) {
        return cipherValue;
    }

    private byte[] digest(byte[] input, byte[] salt) {
        SM3Digest sm3Digest = new SM3Digest();
        byte[] updateByte = this.concat(input, salt);
        sm3Digest.update(updateByte, 0, updateByte.length);
        byte[] result = new byte[sm3Digest.getDigestSize()];
        sm3Digest.doFinal(result, 0);
        return result;
    }

    private byte[] concat(byte[] input, byte[] salt) {
        int inputLength = input.length;
        int saltLength = salt.length;
        byte[] result = new byte[inputLength + saltLength];
        System.arraycopy(input, 0, result, 0, inputLength);
        System.arraycopy(salt, 0, result, inputLength, saltLength);
        return result;
    }

    public String getType() {
        return "SM3";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public byte[] getSm3Salt() {
        return this.sm3Salt;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }

    @Generated
    public void setSm3Salt(byte[] sm3Salt) {
        this.sm3Salt = sm3Salt;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

