/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.rule;

import com.google.common.base.Strings;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.dbdiscovery.algorithm.config.AlgorithmProvidedDatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.rule.DatabaseDiscoveryDataSourceRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.rule.DatabaseDiscoveryHeartBeatConfiguration;
import org.apache.shardingsphere.dbdiscovery.heartbeat.HeartbeatJob;
import org.apache.shardingsphere.dbdiscovery.rule.DatabaseDiscoveryDataSourceRule;
import org.apache.shardingsphere.dbdiscovery.spi.DatabaseDiscoveryType;
import org.apache.shardingsphere.infra.aware.DataSourceNameAware;
import org.apache.shardingsphere.infra.aware.DataSourceNameAwareFactory;
import org.apache.shardingsphere.infra.config.TypedSPIConfiguration;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmFactory;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.event.DataSourceStatusChangedEvent;
import org.apache.shardingsphere.infra.rule.event.impl.DataSourceNameDisabledEvent;
import org.apache.shardingsphere.infra.rule.event.impl.PrimaryDataSourceChangedEvent;
import org.apache.shardingsphere.infra.rule.identifier.scope.SchemaRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataSourceContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.ExportableRule;
import org.apache.shardingsphere.infra.rule.identifier.type.StatusContainedRule;
import org.apache.shardingsphere.infra.schedule.CronJob;
import org.apache.shardingsphere.schedule.core.api.ModeScheduleContext;
import org.apache.shardingsphere.schedule.core.api.ModeScheduleContextFactory;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;

public final class DatabaseDiscoveryRule
implements SchemaRule,
DataSourceContainedRule,
StatusContainedRule,
ExportableRule {
    private final Map<String, DatabaseDiscoveryType> discoveryTypes;
    private final Map<String, DatabaseDiscoveryDataSourceRule> dataSourceRules;

    public DatabaseDiscoveryRule(String schemaName, Map<String, DataSource> dataSourceMap, DatabaseDiscoveryRuleConfiguration config) {
        this(schemaName, dataSourceMap, config.getDataSources(), config.getDiscoveryHeartbeats(), DatabaseDiscoveryRule.getDiscoveryTypes(config.getDiscoveryTypes()));
    }

    public DatabaseDiscoveryRule(String schemaName, Map<String, DataSource> dataSourceMap, AlgorithmProvidedDatabaseDiscoveryRuleConfiguration config) {
        this(schemaName, dataSourceMap, config.getDataSources(), config.getDiscoveryHeartbeats(), config.getDiscoveryTypes());
    }

    private DatabaseDiscoveryRule(String schemaName, Map<String, DataSource> dataSourceMap, Collection<DatabaseDiscoveryDataSourceRuleConfiguration> dataSourceRuleConfigs, Map<String, DatabaseDiscoveryHeartBeatConfiguration> heartBeatConfig, Map<String, DatabaseDiscoveryType> discoveryTypes) {
        this.discoveryTypes = discoveryTypes;
        this.dataSourceRules = this.getDataSourceRules(dataSourceRuleConfigs, heartBeatConfig);
        this.findMasterSlaveRelation(schemaName, dataSourceMap);
        this.initAware();
        this.initHeartBeatJobs(schemaName, dataSourceMap);
    }

    private static Map<String, DatabaseDiscoveryType> getDiscoveryTypes(Map<String, ShardingSphereAlgorithmConfiguration> discoveryTypesConfig) {
        LinkedHashMap<String, DatabaseDiscoveryType> result = new LinkedHashMap<String, DatabaseDiscoveryType>(discoveryTypesConfig.size(), 1.0f);
        for (Map.Entry<String, ShardingSphereAlgorithmConfiguration> entry : discoveryTypesConfig.entrySet()) {
            result.put(entry.getKey(), (DatabaseDiscoveryType)ShardingSphereAlgorithmFactory.createAlgorithm((TypedSPIConfiguration)((TypedSPIConfiguration)entry.getValue()), DatabaseDiscoveryType.class));
        }
        return result;
    }

    private Map<String, DatabaseDiscoveryDataSourceRule> getDataSourceRules(Collection<DatabaseDiscoveryDataSourceRuleConfiguration> dataSources, Map<String, DatabaseDiscoveryHeartBeatConfiguration> heartbeatConfig) {
        HashMap<String, DatabaseDiscoveryDataSourceRule> result = new HashMap<String, DatabaseDiscoveryDataSourceRule>(dataSources.size(), 1.0f);
        for (DatabaseDiscoveryDataSourceRuleConfiguration each : dataSources) {
            result.put(each.getGroupName(), new DatabaseDiscoveryDataSourceRule(each, Strings.isNullOrEmpty((String)each.getDiscoveryHeartbeatName()) ? new Properties() : heartbeatConfig.get(each.getDiscoveryHeartbeatName()).getProps(), this.discoveryTypes.get(each.getDiscoveryTypeName())));
        }
        return result;
    }

    private void findMasterSlaveRelation(String schemaName, Map<String, DataSource> dataSourceMap) {
        for (Map.Entry<String, DatabaseDiscoveryDataSourceRule> entry : this.dataSourceRules.entrySet()) {
            String groupName = entry.getKey();
            DatabaseDiscoveryDataSourceRule dataSourceRule = entry.getValue();
            DatabaseDiscoveryType databaseDiscoveryType = dataSourceRule.getDatabaseDiscoveryType();
            HashMap<String, DataSource> originalDataSourceMap = new HashMap<String, DataSource>(dataSourceMap);
            Collection<String> disabledDataSourceNames = dataSourceRule.getDisabledDataSourceNames();
            try {
                databaseDiscoveryType.checkDatabaseDiscoveryConfiguration(schemaName, originalDataSourceMap);
            }
            catch (SQLException ex) {
                throw new ShardingSphereException((Exception)ex);
            }
            databaseDiscoveryType.updatePrimaryDataSource(schemaName, originalDataSourceMap, disabledDataSourceNames, groupName);
            dataSourceRule.updatePrimaryDataSourceName(databaseDiscoveryType.getPrimaryDataSource());
            databaseDiscoveryType.updateMemberState(schemaName, originalDataSourceMap, groupName);
        }
    }

    private void initAware() {
        DataSourceNameAwareFactory.getInstance().getDataSourceNameAware().ifPresent(optional -> optional.setRule((ShardingSphereRule)this));
    }

    public DatabaseDiscoveryDataSourceRule getSingleDataSourceRule() {
        return this.dataSourceRules.values().iterator().next();
    }

    public Optional<DatabaseDiscoveryDataSourceRule> findDataSourceRule(String dataSourceName) {
        return Optional.ofNullable(this.dataSourceRules.get(dataSourceName));
    }

    public Map<String, Collection<String>> getDataSourceMapper() {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
        for (Map.Entry<String, DatabaseDiscoveryDataSourceRule> entry : this.dataSourceRules.entrySet()) {
            result.putAll(entry.getValue().getDataSourceMapper());
        }
        return result;
    }

    public void updateStatus(DataSourceStatusChangedEvent event) {
        block4: {
            block3: {
                if (!(event instanceof DataSourceNameDisabledEvent)) break block3;
                for (Map.Entry<String, DatabaseDiscoveryDataSourceRule> entry : this.dataSourceRules.entrySet()) {
                    if (((DataSourceNameDisabledEvent)event).isDisabled()) {
                        entry.getValue().disableDataSource(((DataSourceNameDisabledEvent)event).getQualifiedSchema().getDataSourceName());
                        continue;
                    }
                    entry.getValue().enableDataSource(((DataSourceNameDisabledEvent)event).getQualifiedSchema().getDataSourceName());
                }
                break block4;
            }
            if (!(event instanceof PrimaryDataSourceChangedEvent)) break block4;
            for (Map.Entry<String, DatabaseDiscoveryDataSourceRule> entry : this.dataSourceRules.entrySet()) {
                if (!entry.getValue().getGroupName().equals(((PrimaryDataSourceChangedEvent)event).getQualifiedSchema().getGroupName())) continue;
                entry.getValue().updatePrimaryDataSourceName(((PrimaryDataSourceChangedEvent)event).getQualifiedSchema().getDataSourceName());
            }
        }
    }

    public Map<String, Supplier<Object>> getExportedMethods() {
        HashMap<String, Supplier<Object>> result = new HashMap<String, Supplier<Object>>(1, 1.0f);
        result.put("primary_data_source", this::exportPrimaryDataSourceMap);
        return result;
    }

    private Map<String, String> exportPrimaryDataSourceMap() {
        HashMap<String, String> result = new HashMap<String, String>(this.dataSourceRules.size(), 1.0f);
        this.dataSourceRules.forEach((name, dataSourceRule) -> result.put(dataSourceRule.getGroupName(), dataSourceRule.getPrimaryDataSourceName()));
        return result;
    }

    private void initHeartBeatJobs(String schemaName, Map<String, DataSource> dataSourceMap) {
        Optional modeScheduleContext = ModeScheduleContextFactory.getInstance().get();
        if (modeScheduleContext.isPresent()) {
            for (Map.Entry<String, DatabaseDiscoveryDataSourceRule> entry : this.dataSourceRules.entrySet()) {
                Map<String, DataSource> dataSources = dataSourceMap.entrySet().stream().filter(dataSource -> !((DatabaseDiscoveryDataSourceRule)entry.getValue()).getDisabledDataSourceNames().contains(dataSource.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                CronJob job = new CronJob(entry.getValue().getDatabaseDiscoveryType().getType() + "-" + schemaName + "-" + entry.getValue().getGroupName(), each -> new HeartbeatJob(schemaName, dataSources, ((DatabaseDiscoveryDataSourceRule)entry.getValue()).getGroupName(), ((DatabaseDiscoveryDataSourceRule)entry.getValue()).getDatabaseDiscoveryType(), ((DatabaseDiscoveryDataSourceRule)entry.getValue()).getDisabledDataSourceNames()).execute(null), entry.getValue().getHeartbeatProps().getProperty("keep-alive-cron"));
                ((ModeScheduleContext)modeScheduleContext.get()).startCronJob(job);
            }
        }
    }

    public String getType() {
        return DatabaseDiscoveryRule.class.getSimpleName();
    }

    @Generated
    public Map<String, DatabaseDiscoveryDataSourceRule> getDataSourceRules() {
        return this.dataSourceRules;
    }

    static {
        ShardingSphereServiceLoader.register(DatabaseDiscoveryType.class);
        ShardingSphereServiceLoader.register(DataSourceNameAware.class);
    }
}

