/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.datasource.config.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.yaml.YamlJdbcConfiguration;
import org.apache.shardingsphere.infra.database.metadata.url.JdbcUrlAppender;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.datasource.pool.metadata.type.hikari.HikariDataSourcePoolFieldMetaData;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;

public final class StandardPipelineDataSourceConfiguration
implements PipelineDataSourceConfiguration {
    public static final String TYPE = "JDBC";
    private static final String DATA_SOURCE_CLASS_NAME = "dataSourceClassName";
    private final String parameter;
    private final DataSourceProperties dataSourceProperties;
    private final YamlJdbcConfiguration jdbcConfig;
    private final DatabaseType databaseType;

    public StandardPipelineDataSourceConfiguration(String parameter) {
        this(parameter, (Map)YamlEngine.unmarshal((String)parameter, Map.class));
    }

    public StandardPipelineDataSourceConfiguration(Map<String, Object> yamlDataSourceConfig) {
        this(YamlEngine.marshal(yamlDataSourceConfig), yamlDataSourceConfig);
    }

    private StandardPipelineDataSourceConfiguration(String parameter, Map<String, Object> yamlConfig) {
        this.parameter = parameter;
        if (!yamlConfig.containsKey(DATA_SOURCE_CLASS_NAME)) {
            yamlConfig.put(DATA_SOURCE_CLASS_NAME, "com.zaxxer.hikari.HikariDataSource");
        }
        this.dataSourceProperties = new YamlDataSourceConfigurationSwapper().swapToDataSourceProperties(yamlConfig);
        yamlConfig.remove(DATA_SOURCE_CLASS_NAME);
        this.jdbcConfig = (YamlJdbcConfiguration)YamlEngine.unmarshal((String)YamlEngine.marshal(yamlConfig), YamlJdbcConfiguration.class, (boolean)true);
        this.databaseType = DatabaseTypeRegistry.getDatabaseTypeByURL((String)this.jdbcConfig.getJdbcUrl());
    }

    public StandardPipelineDataSourceConfiguration(String jdbcUrl, String username, String password) {
        this(StandardPipelineDataSourceConfiguration.wrapParameter(jdbcUrl, username, password));
    }

    private static Map<String, Object> wrapParameter(String jdbcUrl, String username, String password) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(3, 1.0f);
        HikariDataSourcePoolFieldMetaData fieldMetaData = new HikariDataSourcePoolFieldMetaData();
        result.put(fieldMetaData.getJdbcUrlFieldName(), jdbcUrl);
        result.put(fieldMetaData.getUsernameFieldName(), username);
        result.put(fieldMetaData.getPasswordFieldName(), password);
        return result;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Object getDataSourceConfiguration() {
        return this.dataSourceProperties;
    }

    @Override
    public void appendJDBCQueryProperties(Properties queryProps) {
        this.jdbcConfig.setJdbcUrl(new JdbcUrlAppender().appendQueryProperties(this.jdbcConfig.getJdbcUrl(), queryProps));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StandardPipelineDataSourceConfiguration)) {
            return false;
        }
        StandardPipelineDataSourceConfiguration other = (StandardPipelineDataSourceConfiguration)o;
        String this$parameter = this.getParameter();
        String other$parameter = other.getParameter();
        return !(this$parameter == null ? other$parameter != null : !this$parameter.equals(other$parameter));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $parameter = this.getParameter();
        result = result * 59 + ($parameter == null ? 43 : $parameter.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getParameter() {
        return this.parameter;
    }

    @Generated
    public YamlJdbcConfiguration getJdbcConfig() {
        return this.jdbcConfig;
    }

    @Override
    @Generated
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }
}

