/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.rulealtered;

import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.JobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.core.api.GovernanceRepositoryAPI;
import org.apache.shardingsphere.data.pipeline.core.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredJobContext;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredJobPreparer;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredJobSchedulerCenter;
import org.apache.shardingsphere.elasticjob.api.ShardingContext;
import org.apache.shardingsphere.elasticjob.simple.job.SimpleJob;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.rule.ScalingReleaseSchemaNameLockEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuleAlteredJob
implements SimpleJob {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleAlteredJob.class);
    private final GovernanceRepositoryAPI governanceRepositoryAPI = PipelineAPIFactory.getGovernanceRepositoryAPI();
    private final RuleAlteredJobPreparer jobPreparer = new RuleAlteredJobPreparer();

    public void execute(ShardingContext shardingContext) {
        log.info("Execute job {}-{}", (Object)shardingContext.getJobName(), (Object)shardingContext.getShardingItem());
        JobConfiguration jobConfig = (JobConfiguration)YamlEngine.unmarshal((String)shardingContext.getJobParameter(), JobConfiguration.class, (boolean)true);
        jobConfig.getHandleConfig().setJobShardingItem(Integer.valueOf(shardingContext.getShardingItem()));
        RuleAlteredJobContext jobContext = new RuleAlteredJobContext(jobConfig);
        jobContext.setInitProgress(this.governanceRepositoryAPI.getJobProgress(jobContext.getJobId(), jobContext.getShardingItem()));
        jobContext.setJobPreparer(this.jobPreparer);
        try {
            this.jobPreparer.prepare(jobContext);
        }
        catch (RuntimeException ex) {
            log.error("job prepare failed, {}-{}", (Object)shardingContext.getJobName(), (Object)shardingContext.getShardingItem());
            RuleAlteredJobSchedulerCenter.stop(shardingContext.getJobName());
            jobContext.setStatus(JobStatus.PREPARING_FAILURE);
            this.governanceRepositoryAPI.persistJobProgress(jobContext);
            ScalingReleaseSchemaNameLockEvent event = new ScalingReleaseSchemaNameLockEvent(jobConfig.getWorkflowConfig().getSchemaName());
            ShardingSphereEventBus.getInstance().post((Object)event);
            throw ex;
        }
        this.governanceRepositoryAPI.persistJobProgress(jobContext);
        RuleAlteredJobSchedulerCenter.start(jobContext);
    }
}

