/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.spi.check.consistency;

import com.google.common.base.Strings;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.shardingsphere.data.pipeline.api.check.consistency.DataCalculateParameter;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineDataConsistencyCheckFailedException;
import org.apache.shardingsphere.data.pipeline.core.spi.check.consistency.AbstractStreamingSingleTableDataCalculator;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.PipelineSQLBuilderFactory;
import org.apache.shardingsphere.data.pipeline.spi.sqlbuilder.PipelineSQLBuilder;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataMatchSingleTableDataCalculator
extends AbstractStreamingSingleTableDataCalculator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataMatchSingleTableDataCalculator.class);
    private static final Collection<String> DATABASE_TYPES = DatabaseTypeRegistry.getDatabaseTypeNames();
    private static final String CHUNK_SIZE_KEY = "chunk-size";
    private volatile int chunkSize = 1000;

    public String getAlgorithmType() {
        return "DATA_MATCH";
    }

    public Collection<String> getDatabaseTypes() {
        return DATABASE_TYPES;
    }

    @Override
    public void init() {
        Properties algorithmProps = this.getAlgorithmProps();
        String chunkSizeValue = algorithmProps.getProperty(CHUNK_SIZE_KEY);
        if (!Strings.isNullOrEmpty((String)chunkSizeValue)) {
            int chunkSize = Integer.parseInt(chunkSizeValue);
            if (chunkSize <= 0) {
                log.warn("invalid chunkSize={}, use default value", (Object)chunkSize);
            }
            this.chunkSize = chunkSize;
        }
    }

    @Override
    protected Optional<Object> calculateChunk(DataCalculateParameter dataCalculateParameter) {
        String logicTableName = dataCalculateParameter.getLogicTableName();
        PipelineSQLBuilder sqlBuilder = PipelineSQLBuilderFactory.getSQLBuilder(dataCalculateParameter.getDatabaseType());
        String uniqueKey = dataCalculateParameter.getUniqueKey();
        CalculatedResult previousCalculatedResult = (CalculatedResult)dataCalculateParameter.getPreviousCalculatedResult();
        Number startUniqueKeyValue = null != previousCalculatedResult ? (Number)previousCalculatedResult.getMaxUniqueKeyValue() : (Number)-1;
        String sql = sqlBuilder.buildChunkedQuerySQL(logicTableName, uniqueKey, startUniqueKeyValue);
        try {
            return this.query((DataSource)dataCalculateParameter.getDataSource(), sql, uniqueKey, startUniqueKeyValue, this.chunkSize);
        }
        catch (SQLException ex) {
            throw new PipelineDataConsistencyCheckFailedException(String.format("table %s data check failed.", logicTableName), ex);
        }
    }

    /*
     * Exception decompiling
     */
    private Optional<Object> query(DataSource dataSource, String sql, String uniqueKey, Number startUniqueKeyValue, int chunkSize) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final class CalculatedResult {
        @NonNull
        private final Number maxUniqueKeyValue;
        private final int recordCount;
        private final Collection<Collection<Object>> records;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CalculatedResult)) {
                return false;
            }
            CalculatedResult that = (CalculatedResult)o;
            boolean equalsFirst = new EqualsBuilder().append(this.getRecordCount(), that.getRecordCount()).append((Object)this.getMaxUniqueKeyValue(), (Object)that.getMaxUniqueKeyValue()).isEquals();
            if (!equalsFirst) {
                return false;
            }
            Iterator<Collection<Object>> thisIterator = this.records.iterator();
            Iterator<Collection<Object>> thatIterator = that.records.iterator();
            while (thisIterator.hasNext() && thatIterator.hasNext()) {
                Collection<Object> thisNext = thisIterator.next();
                Collection<Object> thatNext = thatIterator.next();
                if (thisNext.size() != thatNext.size()) {
                    return false;
                }
                Iterator<Object> thisNextIterator = thisNext.iterator();
                Iterator<Object> thatNextIterator = thatNext.iterator();
                while (thisNextIterator.hasNext() && thatNextIterator.hasNext()) {
                    Object thisResult = thisNextIterator.next();
                    Object thatResult = thatNextIterator.next();
                    if (thisResult instanceof SQLXML && thatResult instanceof SQLXML) {
                        return ((SQLXML)thisResult).getString().equals(((SQLXML)thatResult).getString());
                    }
                    if (new EqualsBuilder().append(thisResult, thatResult).isEquals()) continue;
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.getMaxUniqueKeyValue()).append(this.getRecordCount()).append(this.getRecords()).toHashCode();
        }

        @Generated
        public CalculatedResult(@NonNull Number maxUniqueKeyValue, int recordCount, Collection<Collection<Object>> records) {
            if (maxUniqueKeyValue == null) {
                throw new NullPointerException("maxUniqueKeyValue is marked non-null but is null");
            }
            this.maxUniqueKeyValue = maxUniqueKeyValue;
            this.recordCount = recordCount;
            this.records = records;
        }

        @NonNull
        @Generated
        public Number getMaxUniqueKeyValue() {
            return this.maxUniqueKeyValue;
        }

        @Generated
        public int getRecordCount() {
            return this.recordCount;
        }

        @Generated
        public Collection<Collection<Object>> getRecords() {
            return this.records;
        }
    }
}

