/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.repository.cluster.zookeeper.listener;

import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.shardingsphere.infra.instance.definition.InstanceDefinition;
import org.apache.shardingsphere.infra.instance.definition.InstanceType;
import org.apache.shardingsphere.mode.metadata.persist.node.ComputeNode;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.zookeeper.handler.CuratorZookeeperExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SessionConnectionListener
implements ConnectionStateListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SessionConnectionListener.class);
    private static final int RECONNECT_INTERVAL_SECONDS = 5;
    private final InstanceDefinition instanceDefinition;
    private final ClusterPersistRepository repository;

    public void stateChanged(CuratorFramework client, ConnectionState connectionState) {
        if (ConnectionState.LOST == connectionState) {
            boolean reRegistered;
            while (!(reRegistered = this.reRegister(client))) {
            }
            log.debug("instance re-register success instance id: {}", (Object)this.instanceDefinition.getInstanceId().getId());
        }
    }

    private boolean reRegister(CuratorFramework client) {
        try {
            if (client.getZookeeperClient().blockUntilConnectedOrTimedOut()) {
                this.repository.persistEphemeral(ComputeNode.getOnlineInstanceNodePath((String)this.instanceDefinition.getInstanceId().getId(), (InstanceType)this.instanceDefinition.getInstanceType()), "");
                return true;
            }
            this.sleepInterval();
            return false;
        }
        catch (InterruptedException ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
            return true;
        }
    }

    private void sleepInterval() {
        TimeUnit.SECONDS.sleep(5L);
    }

    @Generated
    public SessionConnectionListener(InstanceDefinition instanceDefinition, ClusterPersistRepository repository) {
        this.instanceDefinition = instanceDefinition;
        this.repository = repository;
    }
}

