/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.subscriber;

import com.google.common.eventbus.Subscribe;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.metadata.schema.QualifiedSchema;
import org.apache.shardingsphere.infra.rule.event.impl.DataSourceDisabledEvent;
import org.apache.shardingsphere.infra.rule.event.impl.PrimaryDataSourceChangedEvent;
import org.apache.shardingsphere.infra.storage.StorageNodeDataSource;
import org.apache.shardingsphere.infra.storage.StorageNodeRole;
import org.apache.shardingsphere.infra.storage.StorageNodeStatus;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.node.StorageStatusNode;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;

public final class StorageNodeStatusSubscriber {
    private final ClusterPersistRepository repository;

    public StorageNodeStatusSubscriber(ClusterPersistRepository repository) {
        this.repository = repository;
        ShardingSphereEventBus.getInstance().register((Object)this);
    }

    @Subscribe
    public void update(DataSourceDisabledEvent event) {
        this.repository.persist(StorageStatusNode.getStatusPath(new QualifiedSchema(event.getSchemaName(), event.getGroupName(), event.getDataSourceName())), YamlEngine.marshal((Object)event.getStorageNodeDataSource()));
    }

    @Subscribe
    public void update(PrimaryDataSourceChangedEvent event) {
        this.repository.persist(StorageStatusNode.getStatusPath(event.getQualifiedSchema()), YamlEngine.marshal((Object)new StorageNodeDataSource(StorageNodeRole.PRIMARY, StorageNodeStatus.ENABLED)));
    }
}

