/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.subscriber;

import com.google.common.base.Strings;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.instance.definition.InstanceId;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.ComputeNodeStatus;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.ComputeNodeStatusChangedEvent;
import org.apache.shardingsphere.mode.metadata.persist.node.ComputeNode;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;

public final class ComputeNodeStatusSubscriber {
    private final ClusterPersistRepository repository;

    public ComputeNodeStatusSubscriber(ClusterPersistRepository repository) {
        this.repository = repository;
        ShardingSphereEventBus.getInstance().register((Object)this);
    }

    @Subscribe
    public void update(ComputeNodeStatusChangedEvent event) {
        Collection<String> status;
        String computeStatusNodePath = ComputeNode.getInstanceStatusNodePath((String)new InstanceId(event.getIp(), Integer.valueOf(event.getPort())).getId());
        String yamlContext = this.repository.get(computeStatusNodePath);
        Collection collection = status = Strings.isNullOrEmpty((String)yamlContext) ? new ArrayList() : (Collection)YamlEngine.unmarshal((String)yamlContext, Collection.class);
        if (event.getStatus() == ComputeNodeStatus.CIRCUIT_BREAK) {
            status.add(ComputeNodeStatus.CIRCUIT_BREAK.name());
        } else {
            status.remove(ComputeNodeStatus.CIRCUIT_BREAK.name());
        }
        this.repository.persist(computeStatusNodePath, YamlEngine.marshal(status));
    }
}

