/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.watcher;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.metadata.schema.builder.SystemSchemaBuilderRule;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlTableMetaData;
import org.apache.shardingsphere.infra.yaml.schema.swapper.TableMetaDataYamlSwapper;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceWatcher;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.datasource.DataSourceChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.rule.RuleConfigurationsChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.schema.SchemaChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.version.SchemaVersionChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.event.SchemaAddedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.event.SchemaDeletedEvent;
import org.apache.shardingsphere.mode.metadata.persist.node.SchemaMetaDataNode;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEvent;

public final class MetaDataChangedWatcher
implements GovernanceWatcher<GovernanceEvent> {
    @Override
    public Collection<String> getWatchingKeys() {
        return Collections.singleton(SchemaMetaDataNode.getMetaDataNodePath());
    }

    @Override
    public Collection<DataChangedEvent.Type> getWatchingTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.UPDATED, DataChangedEvent.Type.DELETED);
    }

    @Override
    public Optional<GovernanceEvent> createGovernanceEvent(DataChangedEvent event) {
        if (this.isLogicSchemaChanged(event)) {
            return this.buildLogicSchemaChangedEvent(event);
        }
        if (this.isTableMetaDataChanged(event)) {
            return this.buildTableMetaDataChangedEvent(event);
        }
        if (DataChangedEvent.Type.UPDATED == event.getType()) {
            return this.buildGovernanceEvent(event);
        }
        return Optional.empty();
    }

    private boolean isLogicSchemaChanged(DataChangedEvent event) {
        return SchemaMetaDataNode.getDatabaseNameBySchemaPath((String)event.getKey()).isPresent();
    }

    private boolean isTableMetaDataChanged(DataChangedEvent event) {
        Optional schemaName = SchemaMetaDataNode.getSchemaName((String)event.getKey());
        Optional tableName = SchemaMetaDataNode.getTableName((String)event.getKey());
        return schemaName.isPresent() && tableName.isPresent() && !SystemSchemaBuilderRule.isSystemTable((String)((String)schemaName.get()), (String)((String)tableName.get())) && !Strings.isNullOrEmpty((String)event.getValue());
    }

    private Optional<GovernanceEvent> buildLogicSchemaChangedEvent(DataChangedEvent event) {
        String databaseName = (String)SchemaMetaDataNode.getDatabaseNameBySchemaPath((String)event.getKey()).get();
        if (DataChangedEvent.Type.ADDED == event.getType() || DataChangedEvent.Type.UPDATED == event.getType()) {
            return Optional.of(new SchemaAddedEvent(databaseName));
        }
        if (DataChangedEvent.Type.DELETED == event.getType()) {
            return Optional.of(new SchemaDeletedEvent(databaseName));
        }
        return Optional.empty();
    }

    private Optional<GovernanceEvent> buildGovernanceEvent(DataChangedEvent event) {
        Optional schemaName = SchemaMetaDataNode.getSchemaName((String)event.getKey());
        if (!schemaName.isPresent() || Strings.isNullOrEmpty((String)event.getValue())) {
            return Optional.empty();
        }
        if (event.getKey().equals(SchemaMetaDataNode.getActiveVersionPath((String)((String)schemaName.get())))) {
            return Optional.of(new SchemaVersionChangedEvent((String)schemaName.get(), event.getValue()));
        }
        Optional schemaVersion = SchemaMetaDataNode.getVersionByDataSourcesPath((String)event.getKey());
        if (schemaVersion.isPresent()) {
            return Optional.of(this.createDataSourceChangedEvent((String)schemaName.get(), (String)schemaVersion.get(), event));
        }
        schemaVersion = SchemaMetaDataNode.getVersionByRulesPath((String)event.getKey());
        if (schemaVersion.isPresent()) {
            return Optional.of(this.createRuleChangedEvent((String)schemaName.get(), (String)schemaVersion.get(), event));
        }
        return Optional.empty();
    }

    private DataSourceChangedEvent createDataSourceChangedEvent(String schemaName, String schemaVersion, DataChangedEvent event) {
        Map yamlDataSources = (Map)YamlEngine.unmarshal((String)event.getValue(), Map.class);
        HashMap<String, DataSourceProperties> dataSourcePropertiesMap = yamlDataSources.isEmpty() ? new HashMap<String, DataSourceProperties>() : (Map)yamlDataSources.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new YamlDataSourceConfigurationSwapper().swapToDataSourceProperties((Map)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
        return new DataSourceChangedEvent(schemaName, schemaVersion, dataSourcePropertiesMap);
    }

    private GovernanceEvent createRuleChangedEvent(String schemaName, String schemaVersion, DataChangedEvent event) {
        return new RuleConfigurationsChangedEvent(schemaName, schemaVersion, this.getRuleConfigurations(event.getValue()));
    }

    private Collection<RuleConfiguration> getRuleConfigurations(String yamlContent) {
        LinkedList rules = Strings.isNullOrEmpty((String)yamlContent) ? new LinkedList() : (Collection)YamlEngine.unmarshal((String)yamlContent, Collection.class, (boolean)true);
        return new YamlRuleConfigurationSwapperEngine().swapToRuleConfigurations(rules);
    }

    private Optional<GovernanceEvent> buildTableMetaDataChangedEvent(DataChangedEvent event) {
        String schemaName = (String)SchemaMetaDataNode.getSchemaName((String)event.getKey()).get();
        String tableName = (String)SchemaMetaDataNode.getTableName((String)event.getKey()).get();
        if (DataChangedEvent.Type.DELETED == event.getType()) {
            return Optional.of(new SchemaChangedEvent(schemaName, null, tableName));
        }
        return Optional.of(new SchemaChangedEvent(schemaName, new TableMetaDataYamlSwapper().swapToObject((YamlTableMetaData)YamlEngine.unmarshal((String)event.getValue(), YamlTableMetaData.class)), null));
    }
}

