/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.cache.subscriber;

import com.google.common.eventbus.Subscribe;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.cache.event.StartScalingEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.rule.ScalingReleaseSchemaNameLockEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.rule.ScalingTaskFinishedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.version.SchemaVersionPreparedEvent;
import org.apache.shardingsphere.mode.metadata.persist.node.SchemaMetaDataNode;
import org.apache.shardingsphere.mode.metadata.persist.service.SchemaVersionPersistService;
import org.apache.shardingsphere.mode.persist.PersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScalingRegistrySubscriber {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScalingRegistrySubscriber.class);
    private final ClusterPersistRepository repository;
    private final SchemaVersionPersistService schemaVersionPersistService;

    public ScalingRegistrySubscriber(ClusterPersistRepository repository) {
        this.repository = repository;
        this.schemaVersionPersistService = new SchemaVersionPersistService((PersistRepository)repository);
        ShardingSphereEventBus.getInstance().register((Object)this);
    }

    @Subscribe
    public void startScaling(SchemaVersionPreparedEvent event) {
        String activeVersion = (String)this.schemaVersionPersistService.getSchemaActiveVersion(event.getSchemaName()).get();
        String sourceDataSource = this.repository.get(SchemaMetaDataNode.getMetaDataDataSourcePath((String)event.getSchemaName(), (String)activeVersion));
        String targetDataSource = this.repository.get(SchemaMetaDataNode.getMetaDataDataSourcePath((String)event.getSchemaName(), (String)event.getVersion()));
        String sourceRule = this.repository.get(SchemaMetaDataNode.getRulePath((String)event.getSchemaName(), (String)activeVersion));
        String targetRule = this.repository.get(SchemaMetaDataNode.getRulePath((String)event.getSchemaName(), (String)event.getVersion()));
        log.info("start scaling job, locked the schema name, event={}", (Object)event);
        StartScalingEvent startScalingEvent = new StartScalingEvent(event.getSchemaName(), sourceDataSource, sourceRule, targetDataSource, targetRule, Integer.parseInt(activeVersion), Integer.parseInt(event.getVersion()));
        ShardingSphereEventBus.getInstance().post((Object)startScalingEvent);
    }

    @Subscribe
    public void scalingTaskFinished(ScalingTaskFinishedEvent event) {
        log.info("scalingTaskFinished, event={}", (Object)event);
        int targetActiveVersion = event.getTargetActiveVersion();
        Optional activeVersion = this.schemaVersionPersistService.getSchemaActiveVersion(event.getTargetSchemaName());
        if (activeVersion.isPresent() && targetActiveVersion == Integer.parseInt((String)activeVersion.get())) {
            this.schemaVersionPersistService.persistActiveVersion(event.getTargetSchemaName(), event.getTargetNewVersion() + "");
            this.schemaVersionPersistService.deleteVersion(event.getTargetSchemaName(), targetActiveVersion + "");
        } else {
            log.error("targetActiveVersion does not match current activeVersion, targetActiveVersion={}, activeVersion={}", (Object)targetActiveVersion, activeVersion.orElse(null));
        }
        ScalingReleaseSchemaNameLockEvent releaseLockEvent = new ScalingReleaseSchemaNameLockEvent(event.getTargetSchemaName());
        ShardingSphereEventBus.getInstance().post((Object)releaseLockEvent);
    }
}

