/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry;

import com.google.common.eventbus.EventBus;
import lombok.Generated;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceWatcher;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;

public final class GovernanceWatcherFactory {
    private final ClusterPersistRepository repository;

    public void watchListeners() {
        for (GovernanceWatcher each : ShardingSphereServiceLoader.getSingletonServiceInstances(GovernanceWatcher.class)) {
            this.watch(each);
        }
    }

    private void watch(GovernanceWatcher<?> listener) {
        for (String each : listener.getWatchingKeys()) {
            this.watch(each, listener);
        }
    }

    private void watch(String watchingKey, GovernanceWatcher<?> listener) {
        this.repository.watch(watchingKey, dataChangedEventListener -> {
            if (listener.getWatchingTypes().contains(dataChangedEventListener.getType())) {
                listener.createGovernanceEvent(dataChangedEventListener).ifPresent(arg_0 -> ((EventBus)ShardingSphereEventBus.getInstance()).post(arg_0));
            }
        });
    }

    @Generated
    public GovernanceWatcherFactory(ClusterPersistRepository repository) {
        this.repository = repository;
    }

    static {
        ShardingSphereServiceLoader.register(GovernanceWatcher.class);
    }
}

