/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.future.lock.service;

import java.util.Collection;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.future.lock.service.GlobalLockNode;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.future.lock.service.LockState;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepositoryException;

public final class GlobalLockRegistryService {
    private final ClusterPersistRepository repository;

    public GlobalLockRegistryService(ClusterPersistRepository repository) {
        this.repository = repository;
    }

    public void initGlobalLockRoot() {
        this.repository.persist(GlobalLockNode.getGlobalLocksNodePath(), "");
        this.repository.persist(GlobalLockNode.getGlobalAckNodePath(), "");
    }

    public Collection<String> synchronizeAllGlobalLock() {
        return this.repository.getChildrenKeys(GlobalLockNode.getGlobalLocksNodePath());
    }

    public boolean tryLock(String lockName) {
        try {
            this.repository.persistEphemeral(lockName, LockState.LOCKED.name());
            return true;
        }
        catch (ClusterPersistRepositoryException ignored) {
            return false;
        }
    }

    public void releaseLock(String lockName) {
        this.repository.delete(lockName);
    }

    public void ackLock(String lockName, String lockValue) {
        this.repository.persistEphemeral(lockName, lockValue);
    }

    public void releaseAckLock(String lockName) {
        this.repository.delete(lockName);
    }
}

