/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.future.lock;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.lock.ShardingSphereGlobalLock;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.future.lock.service.GlobalLockNode;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.future.lock.service.GlobalLockRegistryService;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.future.lock.service.LockState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShardingSphereDistributeGlobalLock
implements ShardingSphereGlobalLock {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShardingSphereDistributeGlobalLock.class);
    private static final int CHECK_ACK_INTERVAL_MILLISECONDS = 1000;
    private static final long DEFAULT_TRY_LOCK_TIMEOUT_MILLISECONDS = 180000L;
    private static final long DEFAULT_REGISTRY_TIMEOUT_MILLISECONDS = 200L;
    private final ComputeNodeInstance currentInstance;
    private final String ownerInstanceId;
    private final AtomicReference<LockState> synchronizedLockState;
    private final GlobalLockRegistryService lockService;
    private final Collection<ComputeNodeInstance> computeNodeInstances;
    private final Set<String> lockedInstances = new CopyOnWriteArraySet<String>();

    public ShardingSphereDistributeGlobalLock(ComputeNodeInstance currentInstance, String ownerInstanceId, GlobalLockRegistryService lockService, Collection<ComputeNodeInstance> computeNodeInstances) {
        this.currentInstance = currentInstance;
        this.ownerInstanceId = ownerInstanceId;
        this.lockService = lockService;
        this.synchronizedLockState = new AtomicReference<LockState>(this.isOwnerInstanceId(this.getCurrentInstanceId()) ? LockState.UNLOCKED : LockState.LOCKED);
        this.computeNodeInstances = computeNodeInstances;
        this.initLockedInstances();
    }

    private void initLockedInstances() {
        this.computeNodeInstances.forEach(each -> this.lockedInstances.add(each.getInstanceDefinition().getInstanceId().getId()));
    }

    private String getCurrentInstanceId() {
        return this.currentInstance.getInstanceDefinition().getInstanceId().getId();
    }

    private boolean isOwnerInstanceId(String lockedInstanceId) {
        return this.ownerInstanceId.equals(lockedInstanceId);
    }

    public boolean tryLock(String lockName) {
        return this.innerTryLock(lockName, 200L);
    }

    public boolean tryLock(String lockName, long timeout) {
        return this.innerTryLock(lockName, timeout);
    }

    private boolean innerTryLock(String lockName, long timeout) {
        if (LockState.LOCKED == this.synchronizedLockState.get()) {
            log.info("innerTryLock, already locked, lockName={}", (Object)lockName);
            return false;
        }
        long count = 0L;
        do {
            if (this.lockService.tryLock(GlobalLockNode.generateSchemaLockName(lockName, this.ownerInstanceId)) && this.isAckOK(timeout - count)) {
                boolean result = this.synchronizedLockState.compareAndSet(LockState.UNLOCKED, LockState.LOCKED);
                log.info("innerTryLock, result={}, lockName={}, lockState={}, globalLock.hashCode={}", new Object[]{result, lockName, this.synchronizedLockState.get(), this.hashCode()});
                return result;
            }
            this.sleepInterval();
        } while (timeout > (count += 1000L));
        log.info("innerTryLock timeout, lockName={}", (Object)lockName);
        return false;
    }

    private boolean isAckOK(long timeout) {
        long count = 0L;
        do {
            if (this.isAckCompleted()) {
                return true;
            }
            this.sleepInterval();
        } while (timeout > (count += 1000L));
        log.info("isAckOK timeout");
        return false;
    }

    private void sleepInterval() {
        try {
            TimeUnit.MILLISECONDS.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void releaseLock(String lockName) {
        log.info("releaseLock, lockName={}", (Object)lockName);
        if (LockState.LOCKED != this.synchronizedLockState.get()) {
            log.info("releaseLock, state is not locked, ignore, lockName={}", (Object)lockName);
            return;
        }
        this.lockService.releaseLock(GlobalLockNode.generateSchemaLockName(lockName, this.ownerInstanceId));
        String currentInstanceId = this.getCurrentInstanceId();
        if (this.isOwnerInstanceId(currentInstanceId)) {
            this.lockedInstances.remove(this.ownerInstanceId);
            this.synchronizedLockState.compareAndSet(LockState.LOCKED, LockState.UNLOCKED);
            return;
        }
        this.releaseAckLock(lockName, currentInstanceId);
        this.synchronizedLockState.compareAndSet(LockState.LOCKED, LockState.UNLOCKED);
    }

    public boolean isLocked(String lockName) {
        return LockState.LOCKED == this.synchronizedLockState.get();
    }

    private boolean isAckCompleted() {
        if (this.computeNodeInstances.size() > this.lockedInstances.size()) {
            return false;
        }
        for (ComputeNodeInstance each : this.computeNodeInstances) {
            if (this.lockedInstances.contains(each.getInstanceDefinition().getInstanceId().getId())) continue;
            return false;
        }
        return true;
    }

    public long getDefaultTimeOut() {
        return 180000L;
    }

    public void ackLock(String lockName, String lockedInstanceId) {
        this.lockService.ackLock(GlobalLockNode.generateSchemaAckLockName(lockName, lockedInstanceId), lockedInstanceId);
        this.lockedInstances.add(lockedInstanceId);
    }

    public void releaseAckLock(String lockName, String lockedInstanceId) {
        this.lockService.releaseAckLock(GlobalLockNode.generateSchemaAckLockName(lockName, lockedInstanceId));
        this.lockedInstances.remove(lockedInstanceId);
        this.synchronizedLockState.compareAndSet(LockState.LOCKED, LockState.UNLOCKED);
    }

    public void addLockedInstance(String lockedInstanceId) {
        this.lockedInstances.add(this.ownerInstanceId);
    }

    public void releaseLockedState(String lockName) {
        if (this.isLocked(lockName)) {
            this.synchronizedLockState.compareAndSet(LockState.LOCKED, LockState.UNLOCKED);
        }
    }
}

